/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.services;

import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceUsernameAttributeProvider;
import org.jasig.cas.services.ReloadableServicesManager;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.util.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public class PrincipalAttributeRegisteredServiceUsernameProvider
implements RegisteredServiceUsernameAttributeProvider {
    private static final long serialVersionUID = -3546719400741715137L;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final String usernameAttribute;

    private PrincipalAttributeRegisteredServiceUsernameProvider() {
        this.usernameAttribute = null;
    }

    public PrincipalAttributeRegisteredServiceUsernameProvider(@NotNull String usernameAttribute) {
        this.usernameAttribute = usernameAttribute;
    }

    public String getUsernameAttribute() {
        return this.usernameAttribute;
    }

    public String resolveUsername(Principal principal, Service service) {
        String principalId = principal.getId();
        Map originalPrincipalAttributes = principal.getAttributes();
        Map<String, Object> attributes = this.getPrincipalAttributes(principal, service);
        if (attributes.containsKey(this.usernameAttribute)) {
            principalId = attributes.get(this.usernameAttribute).toString();
        } else if (originalPrincipalAttributes.containsKey(this.usernameAttribute)) {
            this.logger.warn("The selected username attribute [{}] was retrieved as a direct principal attributes and not through the attribute release policy for service [{}]. CAS is unable to detect new attribute values for [{}] after authentication unless the attribute is explicitly authorized for release via the service attribute release policy.", new Object[]{this.usernameAttribute, service, this.usernameAttribute});
            principalId = originalPrincipalAttributes.get(this.usernameAttribute).toString();
        } else {
            this.logger.warn("Principal [{}] does not have an attribute [{}] among attributes [{}] so CAS cannot provide the user attribute the service expects. CAS will instead return the default principal id [{}]. Ensure the attribute selected as the username is allowed to be released by the service attribute release policy.", new Object[]{principalId, this.usernameAttribute, attributes, principalId});
        }
        this.logger.debug("Principal id to return for [{}] is [{}]. The default principal id is [{}].", new Object[]{service.getId(), principalId, principal.getId()});
        return principalId;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder(null, ToStringStyle.SHORT_PREFIX_STYLE);
        toStringBuilder.append("usernameAttribute", (Object)this.usernameAttribute);
        return toStringBuilder.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PrincipalAttributeRegisteredServiceUsernameProvider rhs = (PrincipalAttributeRegisteredServiceUsernameProvider)obj;
        return new EqualsBuilder().append((Object)this.usernameAttribute, (Object)rhs.usernameAttribute).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.usernameAttribute).toHashCode();
    }

    protected Map<String, Object> getPrincipalAttributes(Principal p, Service service) {
        ApplicationContext context = ApplicationContextProvider.getApplicationContext();
        if (context != null) {
            RegisteredService registeredService;
            this.logger.debug("Located application context to locate the service registry entry");
            ReloadableServicesManager servicesManager = (ReloadableServicesManager)context.getBean(ReloadableServicesManager.class);
            if (servicesManager != null && (registeredService = servicesManager.findServiceBy(service)) != null && registeredService.getAccessStrategy().isServiceAccessAllowed()) {
                this.logger.debug("Located service {} in the registry. Attempting to resolve attributes for {}", (Object)service.getId(), (Object)p.getId());
                if (registeredService.getAttributeReleasePolicy() == null) {
                    this.logger.debug("No attribute release policy is defined for {}. Returning default principal attributes", (Object)service.getId());
                    return p.getAttributes();
                }
                return registeredService.getAttributeReleasePolicy().getAttributes(p);
            }
            this.logger.debug("Could not locate service {} in the registry.", (Object)service.getId());
            throw new UnauthorizedServiceException("screen.service.error.message");
        }
        this.logger.warn("No application context could be detected. Returning default principal attributes");
        return p.getAttributes();
    }
}

