/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.security.Key;
import java.util.HashMap;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;

public class BaseStringCipherExecutor
extends AbstractCipherExecutor<String, String> {
    private static final int ENCRYPTION_KEY_SIZE = 256;
    private static final int SIGNING_KEY_SIZE = 512;
    private String contentEncryptionAlgorithmIdentifier;
    private Key secretKeyEncryptionKey;

    private BaseStringCipherExecutor() {
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning) {
        this(secretKeyEncryption, secretKeySigning, "A128CBC-HS256");
    }

    public BaseStringCipherExecutor(String secretKeyEncryption, String secretKeySigning, String contentEncryptionAlgorithmIdentifier) {
        String signingKeyToUse;
        if (StringUtils.isBlank((CharSequence)contentEncryptionAlgorithmIdentifier)) {
            this.logger.debug("contentEncryptionAlgorithmIdentifier is not defined");
            return;
        }
        String secretKeyToUse = secretKeyEncryption;
        if (StringUtils.isBlank((CharSequence)secretKeyToUse)) {
            this.logger.warn("Secret key for encryption is not defined. CAS will attempt to auto-generate the encryption key");
            secretKeyToUse = this.generateOctetJsonWebKeyOfSize(256);
            this.logger.warn("Generated encryption key {} of size {}. The generated key MUST be added to CAS settings.", (Object)secretKeyToUse, (Object)256);
        }
        if (StringUtils.isBlank((CharSequence)(signingKeyToUse = secretKeySigning))) {
            this.logger.warn("Secret key for signing is not defined. CAS will attempt to auto-generate the signing key");
            signingKeyToUse = this.generateOctetJsonWebKeyOfSize(512);
            this.logger.warn("Generated signing key {} of size {}. The generated key MUST be added to CAS settings.", (Object)signingKeyToUse, (Object)512);
        }
        this.setSigningKey(signingKeyToUse);
        this.secretKeyEncryptionKey = this.prepareJsonWebTokenKey(secretKeyToUse);
        this.contentEncryptionAlgorithmIdentifier = contentEncryptionAlgorithmIdentifier;
        this.logger.debug("Initialized cipher encryption sequence via [{}]", (Object)contentEncryptionAlgorithmIdentifier);
    }

    @Override
    public String encode(String value) {
        String encoded = this.encryptValue(value);
        String signed = new String(this.sign(encoded.getBytes()));
        return signed;
    }

    @Override
    public String decode(String value) {
        byte[] encoded = this.verifySignature(value.getBytes());
        if (encoded != null && encoded.length > 0) {
            return this.decryptValue(new String(encoded));
        }
        return null;
    }

    private Key prepareJsonWebTokenKey(String secret) {
        try {
            HashMap<String, String> keys = new HashMap<String, String>(2);
            keys.put("kty", "oct");
            keys.put("k", secret);
            JsonWebKey jwk = JsonWebKey.Factory.newJwk(keys);
            return jwk.getKey();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    private String encryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setPayload(value);
            jwe.setAlgorithmHeaderValue("dir");
            jwe.setEncryptionMethodHeaderParameter(this.contentEncryptionAlgorithmIdentifier);
            jwe.setKey(this.secretKeyEncryptionKey);
            this.logger.debug("Encrypting via [{}]", (Object)this.contentEncryptionAlgorithmIdentifier);
            return jwe.getCompactSerialization();
        }
        catch (Exception e) {
            throw new RuntimeException("Ensure that you have installed JCE Unlimited Strength Jurisdiction Policy Files. " + e.getMessage(), e);
        }
    }

    private String decryptValue(@NotNull String value) {
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            jwe.setKey(this.secretKeyEncryptionKey);
            jwe.setCompactSerialization(value);
            this.logger.debug("Decrypting value...");
            return jwe.getPayload();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }
}

