/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.util.Map;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.crypto.AesCipherService;
import org.jasig.cas.util.AbstractCipherExecutor;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.OctJwkGenerator;
import org.jose4j.jwk.OctetSequenceJsonWebKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryCipherExecutor
extends AbstractCipherExecutor<byte[], byte[]> {
    private static final String UTF8_ENCODING = "UTF-8";
    private static final int SIGNING_KEY_SIZE = 512;
    private static final int ENCRYPTION_KEY_SIZE = 16;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String secretKeyAlgorithm = "AES";
    private String encryptionSecretKey;

    public BinaryCipherExecutor(String encryptionSecretKey, String signingSecretKey) {
        this.verifyAndSetKeys(encryptionSecretKey, signingSecretKey);
    }

    private void verifyAndSetKeys(String encryptionSecretKey, String signingSecretKey) {
        String signingKeyToUse = signingSecretKey;
        if (StringUtils.isBlank((CharSequence)signingKeyToUse)) {
            this.logger.warn("Secret key for signing is not defined. CAS will attempt to auto-generate the signing key");
            signingKeyToUse = this.generateOctetJsonWebKeyOfSize(512);
            this.logger.warn("Generated signing key {} of size {}. The generated key MUST be added to CAS settings.", (Object)signingKeyToUse, (Object)512);
        }
        this.setSigningKey(signingKeyToUse);
        if (StringUtils.isBlank((CharSequence)encryptionSecretKey)) {
            this.logger.warn("No encryption key is defined. CAS will attempt to auto-generate keys");
            this.encryptionSecretKey = RandomStringUtils.randomAlphabetic((int)16);
            this.logger.warn("Generated encryption key {} of size {}. The generated key MUST be added to CAS settings.", (Object)this.encryptionSecretKey, (Object)16);
        } else {
            this.encryptionSecretKey = encryptionSecretKey;
        }
    }

    public void setSecretKeyAlgorithm(String secretKeyAlgorithm) {
        this.secretKeyAlgorithm = secretKeyAlgorithm;
    }

    @Override
    public byte[] encode(byte[] value) {
        try {
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey.getBytes(), this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.encrypt(value, key.getEncoded()).getBytes();
            return this.sign(result);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] decode(byte[] value) {
        try {
            byte[] verifiedValue = this.verifySignature(value);
            SecretKeySpec key = new SecretKeySpec(this.encryptionSecretKey.getBytes(UTF8_ENCODING), this.secretKeyAlgorithm);
            AesCipherService cipher = new AesCipherService();
            byte[] result = cipher.decrypt(verifiedValue, key.getEncoded()).getBytes();
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private String generateOctetJsonWebKeyOfSize(int size) {
        OctetSequenceJsonWebKey octetKey = OctJwkGenerator.generateJwk((int)size);
        Map params = octetKey.toParams(JsonWebKey.OutputControlLevel.INCLUDE_SYMMETRIC);
        return params.get("k").toString();
    }
}

