/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util.services;

import java.security.PublicKey;
import javax.crypto.Cipher;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.util.CompressionUtils;
import org.jasig.cas.util.services.RegisteredServiceCipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRegisteredServiceCipherExecutor
implements RegisteredServiceCipherExecutor {
    private static final String UTF8_ENCODING = "UTF-8";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    public final String encode(String data, RegisteredService service) {
        try {
            PublicKey publicKey = this.createRegisteredServicePublicKey(service);
            byte[] result = this.encodeInternal(data, publicKey, service);
            if (result != null) {
                return CompressionUtils.encodeBase64(result);
            }
        }
        catch (Exception e) {
            this.logger.warn(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    protected byte[] encodeInternal(String data, PublicKey publicKey, RegisteredService registeredService) {
        try {
            Cipher cipher = this.initializeCipherBasedOnServicePublicKey(publicKey, registeredService);
            if (cipher != null) {
                return cipher.doFinal(data.getBytes(UTF8_ENCODING));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    private PublicKey createRegisteredServicePublicKey(RegisteredService registeredService) throws Exception {
        if (registeredService.getPublicKey() == null) {
            this.logger.debug("No public key is defined for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        PublicKey publicKey = registeredService.getPublicKey().createInstance();
        if (publicKey == null) {
            this.logger.debug("No public key instance created for service [{}]. No encoding will take place.", (Object)registeredService);
            return null;
        }
        return publicKey;
    }

    private Cipher initializeCipherBasedOnServicePublicKey(PublicKey publicKey, RegisteredService registeredService) {
        try {
            this.logger.debug("Using public key [{}] to initialize the cipher", (Object)registeredService.getPublicKey());
            Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
            cipher.init(1, publicKey);
            this.logger.debug("Initialized cipher in encrypt-mode via the public key algorithm [{}]", (Object)publicKey.getAlgorithm());
            return cipher;
        }
        catch (Exception e) {
            this.logger.warn("Cipher could not be initialized for service [{}]. Error [{}]", (Object)registeredService, (Object)e.getMessage());
            return null;
        }
    }
}

