/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.hamcrest.Matcher;
import org.jasig.cas.CentralAuthenticationServiceImpl;
import org.jasig.cas.authentication.Authentication;
import org.jasig.cas.authentication.AuthenticationContext;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.DefaultHandlerResult;
import org.jasig.cas.authentication.principal.AbstractWebApplicationService;
import org.jasig.cas.authentication.principal.DefaultPrincipalFactory;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationServiceFactory;
import org.jasig.cas.logout.LogoutManager;
import org.jasig.cas.services.DefaultRegisteredServiceAccessStrategy;
import org.jasig.cas.services.DefaultRegisteredServiceUsernameProvider;
import org.jasig.cas.services.RefuseRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegexMatchingRegisteredServiceProxyPolicy;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceProxyPolicy;
import org.jasig.cas.services.ReturnAllAttributeReleasePolicy;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.services.TestUtils;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.DefaultProxyGrantingTicketFactory;
import org.jasig.cas.ticket.DefaultProxyTicketFactory;
import org.jasig.cas.ticket.DefaultServiceTicketFactory;
import org.jasig.cas.ticket.DefaultTicketFactory;
import org.jasig.cas.ticket.DefaultTicketGrantingTicketFactory;
import org.jasig.cas.ticket.ExpirationPolicy;
import org.jasig.cas.ticket.InvalidTicketException;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.ServiceTicketFactory;
import org.jasig.cas.ticket.TicketFactory;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.TicketGrantingTicketFactory;
import org.jasig.cas.ticket.proxy.ProxyGrantingTicketFactory;
import org.jasig.cas.ticket.proxy.ProxyTicketFactory;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.jasig.cas.validation.Assertion;
import org.joda.time.DateTime;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatcher;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.mock.web.MockHttpServletRequest;

public class CentralAuthenticationServiceImplWithMockitoTests {
    private static final String TGT_ID = "tgt-id";
    private static final String TGT2_ID = "tgt2-id";
    private static final String ST_ID = "st-id";
    private static final String ST2_ID = "st2-id";
    private static final String SVC1_ID = "test1";
    private static final String SVC2_ID = "test2";
    private static final String PRINCIPAL = "principal";
    private CentralAuthenticationServiceImpl cas;
    private Authentication authentication;
    private TicketRegistry ticketRegMock;

    @Before
    public void prepareNewCAS() throws Exception {
        this.authentication = (Authentication)Mockito.mock(Authentication.class);
        Mockito.when((Object)this.authentication.getAuthenticationDate()).thenReturn((Object)DateTime.now());
        BasicCredentialMetaData metadata = new BasicCredentialMetaData((Credential)org.jasig.cas.authentication.TestUtils.getCredentialsWithSameUsernameAndPassword((String)PRINCIPAL));
        HashMap<String, DefaultHandlerResult> successes = new HashMap<String, DefaultHandlerResult>();
        successes.put("handler1", new DefaultHandlerResult((AuthenticationHandler)Mockito.mock(AuthenticationHandler.class), (CredentialMetaData)metadata));
        Mockito.when((Object)this.authentication.getCredentials()).thenReturn(Arrays.asList(metadata));
        Mockito.when((Object)this.authentication.getSuccesses()).thenReturn(successes);
        Mockito.when((Object)this.authentication.getPrincipal()).thenReturn((Object)new DefaultPrincipalFactory().createPrincipal(PRINCIPAL));
        Service service1 = CentralAuthenticationServiceImplWithMockitoTests.getService(SVC1_ID);
        ServiceTicket stMock = CentralAuthenticationServiceImplWithMockitoTests.createMockServiceTicket(ST_ID, service1);
        TicketGrantingTicket tgtRootMock = this.createRootTicketGrantingTicket();
        TicketGrantingTicket tgtMock = this.createMockTicketGrantingTicket(TGT_ID, stMock, false, tgtRootMock, new ArrayList<Authentication>());
        Mockito.when((Object)tgtMock.getProxiedBy()).thenReturn((Object)CentralAuthenticationServiceImplWithMockitoTests.getService("proxiedBy"));
        List authnListMock = (List)Mockito.mock(List.class);
        Mockito.when((Object)authnListMock.size()).thenReturn((Object)2);
        Mockito.when((Object)((Authentication)authnListMock.get(Matchers.anyInt()))).thenReturn((Object)this.authentication);
        Mockito.when((Object)tgtMock.getChainedAuthentications()).thenReturn((Object)authnListMock);
        Mockito.when((Object)stMock.getGrantingTicket()).thenReturn((Object)tgtMock);
        Service service2 = CentralAuthenticationServiceImplWithMockitoTests.getService(SVC2_ID);
        ServiceTicket stMock2 = CentralAuthenticationServiceImplWithMockitoTests.createMockServiceTicket(ST2_ID, service2);
        TicketGrantingTicket tgtMock2 = this.createMockTicketGrantingTicket(TGT2_ID, stMock2, false, tgtRootMock, authnListMock);
        this.mockTicketRegistry(stMock, tgtMock, stMock2, tgtMock2);
        ServicesManager smMock = CentralAuthenticationServiceImplWithMockitoTests.getServicesManager(service1, service2);
        DefaultTicketFactory factory = new DefaultTicketFactory();
        factory.setTicketGrantingTicketFactory((TicketGrantingTicketFactory)new DefaultTicketGrantingTicketFactory());
        factory.setProxyGrantingTicketFactory((ProxyGrantingTicketFactory)new DefaultProxyGrantingTicketFactory());
        factory.setServiceTicketFactory((ServiceTicketFactory)new DefaultServiceTicketFactory());
        factory.setProxyTicketFactory((ProxyTicketFactory)new DefaultProxyTicketFactory());
        factory.initialize();
        this.cas = new CentralAuthenticationServiceImpl(this.ticketRegMock, (TicketFactory)factory, smMock, (LogoutManager)Mockito.mock(LogoutManager.class));
        this.cas.setApplicationEventPublisher((ApplicationEventPublisher)Mockito.mock(ApplicationEventPublisher.class));
    }

    private AuthenticationContext getAuthenticationContext() {
        AuthenticationContext ctx = (AuthenticationContext)Mockito.mock(AuthenticationContext.class);
        Mockito.when((Object)ctx.getAuthentication()).thenReturn((Object)this.authentication);
        return ctx;
    }

    private static ServicesManager getServicesManager(Service service1, Service service2) {
        RegisteredService mockRegSvc1 = CentralAuthenticationServiceImplWithMockitoTests.createMockRegisteredService(service1.getId(), true, CentralAuthenticationServiceImplWithMockitoTests.getServiceProxyPolicy(false));
        RegisteredService mockRegSvc2 = CentralAuthenticationServiceImplWithMockitoTests.createMockRegisteredService("test", false, CentralAuthenticationServiceImplWithMockitoTests.getServiceProxyPolicy(true));
        RegisteredService mockRegSvc3 = CentralAuthenticationServiceImplWithMockitoTests.createMockRegisteredService(service2.getId(), true, CentralAuthenticationServiceImplWithMockitoTests.getServiceProxyPolicy(true));
        ServicesManager smMock = (ServicesManager)Mockito.mock(ServicesManager.class);
        Mockito.when((Object)smMock.findServiceBy((Service)Matchers.argThat((Matcher)new VerifyServiceByIdMatcher(service1.getId())))).thenReturn((Object)mockRegSvc1);
        Mockito.when((Object)smMock.findServiceBy((Service)Matchers.argThat((Matcher)new VerifyServiceByIdMatcher("test")))).thenReturn((Object)mockRegSvc2);
        Mockito.when((Object)smMock.findServiceBy((Service)Matchers.argThat((Matcher)new VerifyServiceByIdMatcher(service2.getId())))).thenReturn((Object)mockRegSvc3);
        return smMock;
    }

    private void mockTicketRegistry(ServiceTicket stMock, TicketGrantingTicket tgtMock, ServiceTicket stMock2, TicketGrantingTicket tgtMock2) {
        this.ticketRegMock = (TicketRegistry)Mockito.mock(TicketRegistry.class);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Matchers.eq((Object)tgtMock.getId()), (Class)Matchers.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Matchers.eq((Object)tgtMock2.getId()), (Class)Matchers.eq(TicketGrantingTicket.class))).thenReturn((Object)tgtMock2);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Matchers.eq((Object)stMock.getId()), (Class)Matchers.eq(ServiceTicket.class))).thenReturn((Object)stMock);
        Mockito.when((Object)this.ticketRegMock.getTicket((String)Matchers.eq((Object)stMock2.getId()), (Class)Matchers.eq(ServiceTicket.class))).thenReturn((Object)stMock2);
        Mockito.when((Object)this.ticketRegMock.getTickets()).thenReturn(Arrays.asList(tgtMock, tgtMock2, stMock, stMock2));
    }

    @Test(expected=InvalidTicketException.class)
    public void verifyNonExistentServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.createProxyGrantingTicket("bad-st", this.getAuthenticationContext());
    }

    @Test(expected=UnauthorizedServiceException.class)
    public void verifyInvalidServiceWhenDelegatingTicketGrantingTicket() throws Exception {
        this.cas.createProxyGrantingTicket(ST_ID, this.getAuthenticationContext());
    }

    @Test(expected=UnauthorizedProxyingException.class)
    public void disallowVendingServiceTicketsWhenServiceIsNotAllowedToProxyCAS1019() throws Exception {
        this.cas.grantServiceTicket(TGT_ID, (Service)TestUtils.getService((String)SVC1_ID), this.getAuthenticationContext());
    }

    @Test(expected=IllegalArgumentException.class)
    public void getTicketGrantingTicketIfTicketIdIsNull() throws InvalidTicketException {
        this.cas.getTicket(null, TicketGrantingTicket.class);
    }

    @Test(expected=InvalidTicketException.class)
    public void getTicketGrantingTicketIfTicketIdIsMissing() throws InvalidTicketException {
        this.cas.getTicket("TGT-9000", TicketGrantingTicket.class);
    }

    @Test
    public void getTicketsWithNoPredicate() {
        Collection c = this.cas.getTickets(Predicates.alwaysTrue());
        Assert.assertEquals((long)c.size(), (long)this.ticketRegMock.getTickets().size());
    }

    @Test
    public void verifyChainedAuthenticationsOnValidation() throws Exception {
        AbstractWebApplicationService svc = TestUtils.getService((String)SVC2_ID);
        ServiceTicket st = this.cas.grantServiceTicket(TGT2_ID, (Service)svc, this.getAuthenticationContext());
        Assert.assertNotNull((Object)st);
        Assertion assertion = this.cas.validateServiceTicket(st.getId(), (Service)svc);
        Assert.assertNotNull((Object)assertion);
        Assert.assertEquals((Object)assertion.getService(), (Object)svc);
        Assert.assertEquals((Object)assertion.getPrimaryAuthentication().getPrincipal().getId(), (Object)PRINCIPAL);
        Assert.assertTrue((assertion.getChainedAuthentications().size() == 2 ? 1 : 0) != 0);
        int i = 0;
        while (i < assertion.getChainedAuthentications().size()) {
            Authentication auth = (Authentication)assertion.getChainedAuthentications().get(i);
            Assert.assertEquals((Object)auth, (Object)this.authentication);
            ++i;
        }
    }

    private TicketGrantingTicket createRootTicketGrantingTicket() {
        TicketGrantingTicket tgtRootMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtRootMock.isExpired()).thenReturn((Object)false);
        Mockito.when((Object)tgtRootMock.getAuthentication()).thenReturn((Object)this.authentication);
        return tgtRootMock;
    }

    private TicketGrantingTicket createMockTicketGrantingTicket(String id, ServiceTicket svcTicket, boolean isExpired, TicketGrantingTicket root, List<Authentication> chainedAuthnList) {
        TicketGrantingTicket tgtMock = (TicketGrantingTicket)Mockito.mock(TicketGrantingTicket.class);
        Mockito.when((Object)tgtMock.isExpired()).thenReturn((Object)isExpired);
        Mockito.when((Object)tgtMock.getId()).thenReturn((Object)id);
        String svcId = svcTicket.getService().getId();
        Mockito.when((Object)tgtMock.grantServiceTicket(Matchers.anyString(), (Service)Matchers.argThat((Matcher)new VerifyServiceByIdMatcher(svcId)), (ExpirationPolicy)Matchers.any(ExpirationPolicy.class), Matchers.anyBoolean(), Matchers.anyBoolean())).thenReturn((Object)svcTicket);
        Mockito.when((Object)tgtMock.getRoot()).thenReturn((Object)root);
        Mockito.when((Object)tgtMock.getChainedAuthentications()).thenReturn(chainedAuthnList);
        Mockito.when((Object)tgtMock.getAuthentication()).thenReturn((Object)this.authentication);
        Mockito.when((Object)svcTicket.getGrantingTicket()).thenReturn((Object)tgtMock);
        return tgtMock;
    }

    private static ServiceTicket createMockServiceTicket(String id, Service svc) {
        ServiceTicket stMock = (ServiceTicket)Mockito.mock(ServiceTicket.class);
        Mockito.when((Object)stMock.getService()).thenReturn((Object)svc);
        Mockito.when((Object)stMock.getId()).thenReturn((Object)id);
        Mockito.when((Object)stMock.isValidFor(svc)).thenReturn((Object)true);
        return stMock;
    }

    private static RegisteredServiceProxyPolicy getServiceProxyPolicy(boolean canProxy) {
        if (!canProxy) {
            return new RefuseRegisteredServiceProxyPolicy();
        }
        return new RegexMatchingRegisteredServiceProxyPolicy(".*");
    }

    private static RegisteredService createMockRegisteredService(String svcId, boolean enabled, RegisteredServiceProxyPolicy proxy) {
        RegisteredService mockRegSvc = (RegisteredService)Mockito.mock(RegisteredService.class);
        Mockito.when((Object)mockRegSvc.getServiceId()).thenReturn((Object)svcId);
        Mockito.when((Object)mockRegSvc.getProxyPolicy()).thenReturn((Object)proxy);
        Mockito.when((Object)mockRegSvc.getName()).thenReturn((Object)svcId);
        Mockito.when((Object)mockRegSvc.matches((Service)Matchers.argThat((Matcher)new VerifyServiceByIdMatcher(svcId)))).thenReturn((Object)true);
        Mockito.when((Object)mockRegSvc.getAttributeReleasePolicy()).thenReturn((Object)new ReturnAllAttributeReleasePolicy());
        Mockito.when((Object)mockRegSvc.getUsernameAttributeProvider()).thenReturn((Object)new DefaultRegisteredServiceUsernameProvider());
        Mockito.when((Object)mockRegSvc.getAccessStrategy()).thenReturn((Object)new DefaultRegisteredServiceAccessStrategy(enabled, true));
        return mockRegSvc;
    }

    private static Service getService(String name) {
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("service", name);
        return new WebApplicationServiceFactory().createService((HttpServletRequest)request);
    }

    private static class VerifyServiceByIdMatcher
    extends ArgumentMatcher<Service> {
        private final String id;

        VerifyServiceByIdMatcher(String id) {
            this.id = id;
        }

        public boolean matches(Object argument) {
            Service s = (Service)argument;
            return s != null && s.getId().equals(this.id);
        }
    }
}

