/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.StringBinding;
import com.sleepycat.je.Cursor;
import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import java.util.ArrayList;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BerkeleyDbTicketRegistry
extends AbstractDistributedTicketRegistry
implements InitializingBean,
DisposableBean {
    private EntryBinding ticketBinding;
    private Database ticketDb;
    private Database catalogDb;
    private Environment environment;
    @NotNull
    private Resource dbHome = new FileSystemResource(".");

    public void afterPropertiesSet() throws Exception {
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setTransactional(true);
        envConfig.setAllowCreate(true);
        envConfig.setTxnNoSync(true);
        envConfig.setTxnWriteNoSync(true);
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(true);
        dbConfig.setAllowCreate(true);
        this.environment = new Environment(this.dbHome.getFile(), envConfig);
        this.ticketDb = this.environment.openDatabase(null, "ticketDb", dbConfig);
        this.catalogDb = this.environment.openDatabase(null, "catalogDb", dbConfig);
        StoredClassCatalog catalog = new StoredClassCatalog(this.catalogDb);
        this.ticketBinding = new SerialBinding((ClassCatalog)catalog, Ticket.class);
    }

    public void addTicket(Ticket ticket) {
        Assert.notNull((Object)ticket, (String)"ticket cannot be null");
        if (this.log.isDebugEnabled()) {
            this.log.debug("Added ticket [" + ticket.getId() + "] to registry.");
        }
        DatabaseEntry dataEntry = new DatabaseEntry();
        try {
            this.ticketBinding.objectToEntry((Object)ticket, dataEntry);
            OperationStatus status = this.ticketDb.put(null, this.getKeyFromString(ticket.getId()), dataEntry);
            if (status != OperationStatus.SUCCESS) {
                throw new DatabaseException("Data insertion got status " + status);
            }
        }
        catch (DatabaseException e) {
            throw new RuntimeException("Ticket Registry DB failed to add ticket : " + ticket, e);
        }
    }

    public Ticket getTicket(String ticketId) {
        Ticket ticket;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Attempting to retrieve ticket [" + ticketId + "]");
        }
        DatabaseEntry theData = new DatabaseEntry();
        try {
            this.ticketDb.get(null, this.getKeyFromString(ticketId), theData, LockMode.DEFAULT);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        Ticket ticket2 = ticket = theData.getData() != null ? (Ticket)this.ticketBinding.entryToObject(theData) : null;
        if (ticket != null && this.log.isDebugEnabled()) {
            this.log.debug("Ticket [" + ticketId + "] found in registry.");
        }
        return this.getProxiedTicketInstance(ticket);
    }

    public boolean deleteTicket(String ticketId) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Removing ticket [" + ticketId + "] from registry");
        }
        try {
            return this.ticketDb.delete(null, this.getKeyFromString(ticketId)) == OperationStatus.SUCCESS;
        }
        catch (DatabaseException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public Collection<Ticket> getTickets() {
        Cursor cursor = null;
        ArrayList<Ticket> tickets = new ArrayList<Ticket>();
        try {
            CursorConfig cconfig = new CursorConfig();
            cconfig.setReadUncommitted(true);
            cursor = this.ticketDb.openCursor(null, cconfig);
            DatabaseEntry foundKey = new DatabaseEntry();
            DatabaseEntry foundData = new DatabaseEntry();
            while (cursor.getNext(foundKey, foundData, LockMode.READ_UNCOMMITTED) == OperationStatus.SUCCESS) {
                if (foundData.getData() == null) continue;
                Ticket ticket = (Ticket)this.ticketBinding.entryToObject(foundData);
                tickets.add(this.getProxiedTicketInstance(ticket));
            }
            cursor.close();
        }
        catch (DatabaseException de) {
            try {
                if (cursor != null) {
                    cursor.close();
                }
            }
            catch (DatabaseException databaseException) {}
            throw new RuntimeException(de);
        }
        return tickets;
    }

    public void setDbHome(Resource dbHome) {
        this.dbHome = dbHome;
    }

    public void destroy() throws Exception {
        this.catalogDb.close();
        this.ticketDb.close();
        this.environment.close();
    }

    protected void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    private DatabaseEntry getKeyFromString(String key) {
        DatabaseEntry de = new DatabaseEntry();
        StringBinding.stringToEntry((String)key, (DatabaseEntry)de);
        return de;
    }
}

