/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jboss.cache.Cache;
import org.jboss.cache.CacheException;
import org.jboss.cache.Node;

public final class JBossCacheTicketRegistry
extends AbstractDistributedTicketRegistry {
    private static final String FQN_TICKET = "ticket";
    @NotNull
    private Cache<String, Ticket> cache;

    protected void updateTicket(Ticket ticket) {
        try {
            this.cache.put(FQN_TICKET, (Object)ticket.getId(), (Object)ticket);
        }
        catch (CacheException e) {
            throw new RuntimeException(e);
        }
    }

    public void addTicket(Ticket ticket) {
        try {
            this.logger.debug("Adding ticket to registry for: {}", (Object)ticket.getId());
            this.cache.put(FQN_TICKET, (Object)ticket.getId(), (Object)ticket);
        }
        catch (CacheException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public boolean deleteTicket(String ticketId) {
        try {
            this.logger.debug("Removing ticket from registry for: ", (Object)ticketId);
            return this.cache.remove(FQN_TICKET, (Object)ticketId) != null;
        }
        catch (CacheException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        try {
            this.logger.debug("Retrieving ticket from registry for: {}", (Object)ticketId);
            return this.getProxiedTicketInstance((Ticket)this.cache.get(FQN_TICKET, (Object)ticketId));
        }
        catch (CacheException e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public Collection<Ticket> getTickets() {
        try {
            Node node = this.cache.getNode(FQN_TICKET);
            if (node == null) {
                return Collections.emptyList();
            }
            Set keys = node.getKeys();
            ArrayList<Ticket> list = new ArrayList<Ticket>();
            for (String key : keys) {
                Ticket ticket = (Ticket)node.get((Object)key);
                if (ticket == null) continue;
                list.add((Ticket)node.get((Object)key));
            }
            return list;
        }
        catch (CacheException e) {
            return Collections.emptyList();
        }
    }

    public void setCache(Cache<String, Ticket> cache) {
        this.cache = cache;
    }

    protected boolean needsCallback() {
        return true;
    }
}

