/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Future;
import javax.validation.constraints.Min;
import net.spy.memcached.MemcachedClient;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.springframework.beans.factory.DisposableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemCacheTicketRegistry
extends AbstractDistributedTicketRegistry
implements DisposableBean {
    private final MemcachedClient client;
    @Min(value=0L)
    private final int tgtTimeout;
    @Min(value=0L)
    private final int stTimeout;
    private boolean synchronizeUpdatesToRegistry = false;

    public MemCacheTicketRegistry(String[] hostnames, int ticketGrantingTicketTimeOut, int serviceTicketTimeOut) {
        this.tgtTimeout = ticketGrantingTicketTimeOut;
        this.stTimeout = serviceTicketTimeOut;
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        String[] stringArray = hostnames;
        int n = hostnames.length;
        int n2 = 0;
        while (n2 < n) {
            String hostname = stringArray[n2];
            String[] hostPort = hostname.split(":");
            addresses.add(new InetSocketAddress(hostPort[0], Integer.parseInt(hostPort[1])));
            ++n2;
        }
        try {
            this.client = new MemcachedClient(addresses);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public MemCacheTicketRegistry(long ticketGrantingTicketTimeOut, long serviceTicketTimeOut, String[] hostnames) {
        this(hostnames, (int)(ticketGrantingTicketTimeOut / 1000L), (int)(serviceTicketTimeOut / 1000L));
    }

    private void handleSynchronousRequest(Future f) {
        try {
            if (this.synchronizeUpdatesToRegistry) {
                f.get();
            }
        }
        catch (Exception exception) {}
    }

    protected void updateTicket(Ticket ticket) {
        if (ticket instanceof TicketGrantingTicket) {
            this.handleSynchronousRequest(this.client.replace(ticket.getId(), this.tgtTimeout, (Object)ticket));
        }
        if (ticket instanceof ServiceTicket) {
            this.handleSynchronousRequest(this.client.replace(ticket.getId(), this.stTimeout, (Object)ticket));
        }
    }

    public void addTicket(Ticket ticket) {
        if (ticket instanceof TicketGrantingTicket) {
            this.handleSynchronousRequest(this.client.add(ticket.getId(), this.tgtTimeout, (Object)ticket));
        }
        if (ticket instanceof ServiceTicket) {
            this.handleSynchronousRequest(this.client.add(ticket.getId(), this.stTimeout, (Object)ticket));
        }
    }

    public boolean deleteTicket(String ticketId) {
        Future f = this.client.delete(ticketId);
        try {
            return (Boolean)f.get();
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public Ticket getTicket(String ticketId) {
        Ticket t = (Ticket)this.client.get(ticketId);
        if (t == null) {
            return null;
        }
        return this.getProxiedTicketInstance(t);
    }

    public Collection<Ticket> getTickets() {
        throw new UnsupportedOperationException("GetTickets not supported.");
    }

    public void destroy() throws Exception {
        this.client.shutdown();
    }

    public void setSynchronizeUpdatesToRegistry(boolean b) {
        this.synchronizeUpdatesToRegistry = b;
    }

    protected boolean needsCallback() {
        return true;
    }
}

