/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support.kryo.serial;

import com.esotericsoftware.kryo.Kryo;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.jasig.cas.authentication.principal.GoogleAccountsService;
import org.jasig.cas.ticket.registry.support.kryo.FieldHelper;
import org.jasig.cas.ticket.registry.support.kryo.serial.AbstractWebApplicationServiceSerializer;

public final class GoogleAccountsServiceSerializer
extends AbstractWebApplicationServiceSerializer<GoogleAccountsService> {
    private static final Constructor CONSTRUCTOR;
    private final PrivateKey privateKey;
    private final PublicKey publicKey;
    private final String alternateUsername;

    static {
        try {
            CONSTRUCTOR = GoogleAccountsService.class.getDeclaredConstructor(String.class, String.class, String.class, String.class, String.class, PrivateKey.class, PublicKey.class, String.class);
            CONSTRUCTOR.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Expected constructor signature not found.", e);
        }
    }

    public GoogleAccountsServiceSerializer(Kryo kryo, FieldHelper helper, PublicKey publicKey, PrivateKey privateKey, String alternateUsername) {
        super(kryo, helper);
        this.publicKey = publicKey;
        this.privateKey = privateKey;
        this.alternateUsername = alternateUsername;
    }

    @Override
    public void write(ByteBuffer buffer, GoogleAccountsService service) {
        super.write(buffer, service);
        this.kryo.writeObject(buffer, this.fieldHelper.getFieldValue(service, "requestId"));
        this.kryo.writeObject(buffer, this.fieldHelper.getFieldValue(service, "relayState"));
    }

    @Override
    protected GoogleAccountsService createService(ByteBuffer buffer, String id, String originalUrl, String artifactId) {
        String requestId = (String)this.kryo.readObject(buffer, String.class);
        String relayState = (String)this.kryo.readObject(buffer, String.class);
        try {
            GoogleAccountsService service = (GoogleAccountsService)CONSTRUCTOR.newInstance(id, originalUrl, artifactId, relayState, requestId, this.privateKey, this.publicKey, this.alternateUsername);
            return service;
        }
        catch (Exception e) {
            throw new IllegalStateException("Error creating SamlService", e);
        }
    }
}

