/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.integration.restlet;

import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.SimpleWebApplicationServiceImpl;
import org.jasig.cas.ticket.InvalidTicketException;
import org.restlet.Context;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.springframework.beans.factory.annotation.Autowire;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Configurable;

@Configurable(preConstruction=true, autowire=Autowire.BY_TYPE)
public final class TicketGrantingTicketResource
extends Resource {
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;
    private final String ticketGrantingTicketId;

    public TicketGrantingTicketResource(Context context, Request request, Response response) {
        super(context, request, response);
        this.ticketGrantingTicketId = (String)request.getAttributes().get("ticketGrantingTicketId");
    }

    public boolean allowDelete() {
        return true;
    }

    public boolean allowPost() {
        return true;
    }

    public void removeRepresentations() throws ResourceException {
        this.centralAuthenticationService.destroyTicketGrantingTicket(this.ticketGrantingTicketId);
        this.getResponse().setStatus(Status.SUCCESS_OK);
    }

    public void acceptRepresentation(Representation entity) throws ResourceException {
        String serviceUrl = (String)this.getRequest().getAttributes().get("service");
        SimpleWebApplicationServiceImpl service = new SimpleWebApplicationServiceImpl(serviceUrl);
        try {
            String serviceTicketId = this.centralAuthenticationService.grantServiceTicket(this.ticketGrantingTicketId, (Service)service);
            this.getResponse().setEntity(serviceTicketId, MediaType.TEXT_PLAIN);
        }
        catch (InvalidTicketException e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_NOT_FOUND, "TicketGrantingTicket could not be found.");
        }
        catch (Exception e) {
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
        }
    }
}

