/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.integration.restlet;

import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.ticket.TicketException;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Reference;
import org.restlet.data.Request;
import org.restlet.data.Status;
import org.restlet.resource.Representation;
import org.restlet.resource.Resource;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.bind.support.WebRequestDataBinder;
import org.springframework.web.context.request.WebRequest;

public class TicketResource
extends Resource {
    private static final Logger log = LoggerFactory.getLogger(TicketResource.class);
    @Autowired
    private CentralAuthenticationService centralAuthenticationService;

    public final boolean allowGet() {
        return false;
    }

    public final boolean allowPost() {
        return true;
    }

    public final void acceptRepresentation(Representation entity) throws ResourceException {
        if (log.isDebugEnabled()) {
            log.debug("Obtaining credentials...");
            log.debug(this.getRequest().getEntityAsForm().toString());
        }
        Credentials c = this.obtainCredentials();
        try {
            String ticketGrantingTicketId = this.centralAuthenticationService.createTicketGrantingTicket(c);
            this.getResponse().setStatus(this.determineStatus());
            Reference ticket_ref = this.getRequest().getResourceRef().addSegment(ticketGrantingTicketId);
            this.getResponse().setLocationRef(ticket_ref);
            this.getResponse().setEntity("<!DOCTYPE HTML PUBLIC \"-//IETF//DTD HTML 2.0//EN\"><html><head><title>" + this.getResponse().getStatus().getCode() + " " + this.getResponse().getStatus().getDescription() + "</title></head><body><h1>TGT Created</h1><form action=\"" + ticket_ref + "\" method=\"POST\">Service:<input type=\"text\" name=\"service\" value=\"\"><br><input type=\"submit\" value=\"Submit\"></form></body></html>", MediaType.TEXT_HTML);
        }
        catch (TicketException e) {
            log.error(e.getMessage(), (Throwable)e);
            this.getResponse().setStatus(Status.CLIENT_ERROR_BAD_REQUEST, e.getMessage());
        }
    }

    protected Status determineStatus() {
        return Status.SUCCESS_CREATED;
    }

    protected Credentials obtainCredentials() {
        UsernamePasswordCredentials c = new UsernamePasswordCredentials();
        WebRequestDataBinder binder = new WebRequestDataBinder((Object)c);
        RestletWebRequest webRequest = new RestletWebRequest(this.getRequest());
        if (log.isDebugEnabled()) {
            log.debug(this.getRequest().getEntityAsForm().toString());
            log.debug("Username from RestletWebRequest: " + webRequest.getParameter("username"));
        }
        binder.bind((WebRequest)webRequest);
        return c;
    }

    protected class RestletWebRequest
    implements WebRequest {
        private final Form form;
        private final Request request;

        public RestletWebRequest(Request request) {
            this.form = TicketResource.this.getRequest().getEntityAsForm();
            this.request = request;
        }

        public boolean checkNotModified(String s) {
            return false;
        }

        public boolean checkNotModified(long lastModifiedTimestamp) {
            return false;
        }

        public String getContextPath() {
            return this.request.getResourceRef().getPath();
        }

        public String getDescription(boolean includeClientInfo) {
            return null;
        }

        public Locale getLocale() {
            return LocaleContextHolder.getLocale();
        }

        public String getParameter(String paramName) {
            return this.form.getFirstValue(paramName);
        }

        public Map<String, String[]> getParameterMap() {
            HashMap<String, String[]> conversion = new HashMap<String, String[]>();
            for (Map.Entry entry : this.form.getValuesMap().entrySet()) {
                conversion.put((String)entry.getKey(), new String[]{(String)entry.getValue()});
            }
            return conversion;
        }

        public String[] getParameterValues(String paramName) {
            return this.form.getValuesArray(paramName);
        }

        public String getRemoteUser() {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isSecure() {
            return this.request.isConfidential();
        }

        public boolean isUserInRole(String role) {
            return false;
        }

        public Object getAttribute(String name, int scope) {
            return null;
        }

        public String[] getAttributeNames(int scope) {
            return null;
        }

        public String getSessionId() {
            return null;
        }

        public Object getSessionMutex() {
            return null;
        }

        public void registerDestructionCallback(String name, Runnable callback, int scope) {
        }

        public void removeAttribute(String name, int scope) {
        }

        public void setAttribute(String name, Object value, int scope) {
        }

        public String getHeader(String s) {
            return null;
        }

        public String[] getHeaderValues(String s) {
            return new String[0];
        }

        public Iterator<String> getHeaderNames() {
            return null;
        }

        public Iterator<String> getParameterNames() {
            return null;
        }

        public Object resolveReference(String s) {
            return null;
        }
    }
}

