/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.authentication.principal;

import java.util.List;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.principal.AbstractLdapPersonDirectoryCredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.CredentialsToPrincipalResolver;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.core.AttributesMapper;

public final class CredentialsToLDAPAttributePrincipalResolver
extends AbstractLdapPersonDirectoryCredentialsToPrincipalResolver {
    @NotNull
    private CredentialsToPrincipalResolver credentialsToPrincipalResolver;

    protected String extractPrincipalId(Credentials credentials) {
        String ldapPrincipal;
        Principal principal = this.credentialsToPrincipalResolver.resolvePrincipal(credentials);
        if (principal == null) {
            this.log.info("Initial principal could not be resolved from request, returning null");
            return null;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Resolved " + principal + ". Trying LDAP resolve now...");
        }
        if ((ldapPrincipal = this.resolveFromLDAP(principal.getId())) == null) {
            this.log.info("Initial principal \"" + principal.getId() + "\" was not found in LDAP, returning null");
        } else {
            this.log.debug("Resolved " + principal + " to " + ldapPrincipal);
        }
        return ldapPrincipal;
    }

    private String resolveFromLDAP(String lookupAttributeValue) {
        List principalList;
        block6: {
            String searchFilter;
            block5: {
                searchFilter = LdapUtils.getFilterWithValues((String)this.getFilter(), (String)lookupAttributeValue);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("LDAP search with filter \"" + searchFilter + "\"");
                }
                try {
                    final String idAttribute = this.getAttributeIds()[0];
                    principalList = this.getLdapTemplate().search(this.getSearchBase(), searchFilter, this.getSearchControls(), new AttributesMapper(){

                        public Object mapFromAttributes(Attributes attrs) throws NamingException {
                            Attribute attribute = attrs.get(idAttribute);
                            if (attribute == null) {
                                CredentialsToLDAPAttributePrincipalResolver.this.log.debug("Principal attribute \"" + idAttribute + "\" " + "not found in LDAP search results. Returning null.");
                                return null;
                            }
                            return attribute.get();
                        }
                    });
                    if (!principalList.isEmpty()) break block5;
                    this.log.debug("LDAP search returned zero results.");
                    return null;
                }
                catch (Exception e) {
                    this.log.error(e.getMessage(), (Throwable)e);
                    return null;
                }
            }
            if (principalList.size() <= 1) break block6;
            this.log.error("LDAP search returned multiple results for filter \"" + searchFilter + "\", " + "which is not allowed.");
            return null;
        }
        return (String)principalList.get(0);
    }

    public boolean supports(Credentials credentials) {
        return this.credentialsToPrincipalResolver.supports(credentials);
    }

    public final void setCredentialsToPrincipalResolver(CredentialsToPrincipalResolver credentialsToPrincipalResolver) {
        this.credentialsToPrincipalResolver = credentialsToPrincipalResolver;
    }
}

