/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap;

import javax.naming.directory.DirContext;
import org.jasig.cas.adaptors.ldap.AbstractLdapUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.principal.UsernamePasswordCredentials;
import org.jasig.cas.util.LdapUtils;
import org.springframework.ldap.NamingException;

public final class FastBindLdapAuthenticationHandler
extends AbstractLdapUsernamePasswordAuthenticationHandler {
    protected boolean authenticateUsernamePasswordInternal(UsernamePasswordCredentials credentials) throws AuthenticationException {
        block6: {
            DirContext dirContext = null;
            try {
                String transformedUsername = this.getPrincipalNameTransformer().transform(credentials.getUsername());
                String bindDn = LdapUtils.getFilterWithValues((String)this.getFilter(), (String)transformedUsername);
                this.log.debug("Performing LDAP bind with credential: " + bindDn);
                dirContext = this.getContextSource().getContext(bindDn, credentials.getPassword());
                if (dirContext == null) break block6;
            }
            catch (NamingException namingException) {
                return false;
            }
            finally {
                if (dirContext != null) {
                    LdapUtils.closeContext(dirContext);
                }
            }
            LdapUtils.closeContext((DirContext)dirContext);
        }
        return true;
    }
}

