/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import javax.naming.directory.DirContext;
import javax.validation.constraints.NotNull;
import org.jasig.cas.monitor.AbstractPoolMonitor;
import org.jasig.cas.monitor.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.pool.DirContextType;
import org.springframework.ldap.pool.factory.PoolingContextSource;

public class PoolingContextSourceMonitor
extends AbstractPoolMonitor {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    @NotNull
    private PoolingContextSource poolingContextSource;

    public void setPoolingContextSource(PoolingContextSource pool) {
        this.poolingContextSource = pool;
    }

    protected StatusCode checkPool() throws Exception {
        boolean success;
        DirContext ctxt = null;
        try {
            ctxt = this.poolingContextSource.getReadOnlyContext();
            success = this.poolingContextSource.getDirContextValidator().validateDirContext(DirContextType.READ_ONLY, ctxt);
        }
        finally {
            if (ctxt != null) {
                ctxt.close();
            }
        }
        return success ? StatusCode.OK : StatusCode.ERROR;
    }

    protected int getIdleCount() {
        return this.poolingContextSource.getNumIdle();
    }

    protected int getActiveCount() {
        return this.poolingContextSource.getNumActive();
    }
}

