/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.monitor;

import org.jasig.cas.monitor.AbstractNamedMonitor;
import org.jasig.cas.monitor.Status;
import org.jasig.cas.monitor.StatusCode;
import org.jasig.cas.util.LdapUtils;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.pool.Validator;

public class ConnectionFactoryMonitor
extends AbstractNamedMonitor<Status> {
    private static final Status OK = new Status(StatusCode.OK);
    private static final Status ERROR = new Status(StatusCode.ERROR);
    private final ConnectionFactory connectionFactory;
    private final Validator<Connection> validator;

    public ConnectionFactoryMonitor(ConnectionFactory factory, Validator<Connection> validator) {
        this.connectionFactory = factory;
        this.validator = validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Status observe() {
        Connection conn = null;
        try {
            conn = this.connectionFactory.getConnection();
            if (!conn.isOpen()) {
                conn.open();
            }
            Status status = this.validator.validate((Object)conn) ? OK : ERROR;
            return status;
        }
        catch (LdapException e) {
            this.logger.warn("Validation failed with error.", (Throwable)e);
        }
        finally {
            LdapUtils.closeConnection(conn);
        }
        return ERROR;
    }
}

