/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.userdetails;

import java.util.ArrayList;
import javax.validation.constraints.NotNull;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapAttribute;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.Response;
import org.ldaptive.SearchExecutor;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class LdapUserDetailsService
implements UserDetailsService {
    public static final String DEFAULT_ROLE_PREFIX = "ROLE_";
    public static final String UNKNOWN_PASSWORD = "<UNKNOWN>";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @NotNull
    private final ConnectionFactory connectionFactory;
    @NotNull
    private final SearchExecutor userSearchExecutor;
    @NotNull
    private final SearchExecutor roleSearchExecutor;
    @NotNull
    private final String userAttributeName;
    @NotNull
    private final String roleAttributeName;
    @NotNull
    private String rolePrefix = "ROLE_";
    private boolean allowMultipleResults;

    public LdapUserDetailsService(ConnectionFactory factory, SearchExecutor userSearchExecutor, SearchExecutor roleSearchExecutor, String userAttributeName, String roleAttributeName) {
        this.connectionFactory = factory;
        this.userSearchExecutor = userSearchExecutor;
        this.roleSearchExecutor = roleSearchExecutor;
        this.userAttributeName = userAttributeName;
        this.roleAttributeName = roleAttributeName;
    }

    public void setRolePrefix(String rolePrefix) {
        this.rolePrefix = rolePrefix;
    }

    public void setAllowMultipleResults(boolean allowMultiple) {
        this.allowMultipleResults = allowMultiple;
    }

    public UserDetails loadUserByUsername(String username) {
        SearchResult roleResult;
        SearchResult userResult;
        try {
            this.logger.debug("Attempting to get details for user {}.", (Object)username);
            Response response = this.userSearchExecutor.search(this.connectionFactory, this.createSearchFilter(this.userSearchExecutor, username));
            this.logger.debug("LDAP user search response: {}", (Object)response);
            userResult = (SearchResult)response.getResult();
        }
        catch (LdapException e) {
            throw new RuntimeException("LDAP error fetching details for user.", e);
        }
        if (userResult.size() == 0) {
            throw new UsernameNotFoundException(username + " not found.");
        }
        if (userResult.size() > 1 && !this.allowMultipleResults) {
            throw new IllegalStateException("Found multiple results for user which is not allowed (allowMultipleResults=false).");
        }
        LdapEntry userResultEntry = userResult.getEntry();
        String userDn = userResultEntry.getDn();
        LdapAttribute userAttribute = userResultEntry.getAttribute(this.userAttributeName);
        if (userAttribute == null) {
            throw new IllegalStateException(this.userAttributeName + " attribute not found in results.");
        }
        String id = userAttribute.getStringValue();
        try {
            this.logger.debug("Attempting to get roles for user {}.", (Object)userDn);
            Response response = this.roleSearchExecutor.search(this.connectionFactory, this.createSearchFilter(this.roleSearchExecutor, userDn));
            this.logger.debug("LDAP role search response: {}", (Object)response);
            roleResult = (SearchResult)response.getResult();
        }
        catch (LdapException e) {
            throw new RuntimeException("LDAP error fetching roles for user.", e);
        }
        ArrayList<SimpleGrantedAuthority> roles = new ArrayList<SimpleGrantedAuthority>(roleResult.size());
        for (LdapEntry entry : roleResult.getEntries()) {
            LdapAttribute roleAttribute = entry.getAttribute(this.roleAttributeName);
            if (roleAttribute == null) {
                this.logger.warn("Role attribute not found on entry {}", (Object)entry);
                continue;
            }
            for (String role : roleAttribute.getStringValues()) {
                roles.add(new SimpleGrantedAuthority(this.rolePrefix + role.toUpperCase()));
            }
        }
        return new User(id, UNKNOWN_PASSWORD, roles);
    }

    private SearchFilter createSearchFilter(SearchExecutor executor, String username) {
        SearchFilter filter = new SearchFilter();
        filter.setFilter(executor.getSearchFilter().getFilter());
        filter.setParameter(0, (Object)username);
        this.logger.debug("Constructed LDAP search filter [{}]", (Object)filter.format());
        return filter;
    }
}

