/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.scribe.up.provider.OAuthProvider;
import org.scribe.utils.OAuthEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.view.RedirectView;

public final class OAuthUtils {
    private static final Logger logger = LoggerFactory.getLogger(OAuthUtils.class);

    public static ModelAndView writeTextError(HttpServletResponse response, String error, int status) {
        return OAuthUtils.writeText(response, "error=" + error, status);
    }

    public static ModelAndView writeText(HttpServletResponse response, String text, int status) {
        try {
            PrintWriter printWriter = response.getWriter();
            response.setStatus(status);
            printWriter.print(text);
        }
        catch (IOException e) {
            logger.error("Failed to write to response", (Throwable)e);
        }
        return null;
    }

    public static ModelAndView redirectToError(String url, String error) {
        if (StringUtils.isBlank((String)url)) {
            url = "/";
        }
        return OAuthUtils.redirectTo(OAuthUtils.addParameter(url, "error", error));
    }

    public static ModelAndView redirectTo(String url) {
        return new ModelAndView((View)new RedirectView(url));
    }

    public static String addParameter(String url, String name, String value) {
        StringBuilder sb = new StringBuilder();
        sb.append(url);
        if (url.indexOf("?") >= 0) {
            sb.append("&");
        } else {
            sb.append("?");
        }
        sb.append(name);
        sb.append("=");
        sb.append(OAuthEncoder.encode((String)value));
        return sb.toString();
    }

    public static OAuthProvider getProviderByType(List<OAuthProvider> providers, String type) {
        for (OAuthProvider provider : providers) {
            if (provider == null || !type.equals(provider.getType())) continue;
            return provider;
        }
        return null;
    }
}

