/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.authentication.handler.support;

import javax.validation.constraints.NotNull;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.authentication.handler.AuthenticationException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.support.oauth.OAuthConfiguration;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.jasig.cas.support.oauth.authentication.principal.OAuthCredentials;
import org.scribe.up.profile.UserProfile;
import org.scribe.up.provider.OAuthProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OAuthAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(OAuthAuthenticationHandler.class);
    @NotNull
    private OAuthConfiguration configuration;

    public boolean supports(Credentials credentials) {
        return credentials != null && OAuthCredentials.class.isAssignableFrom(credentials.getClass());
    }

    protected boolean doAuthentication(Credentials credentials) throws AuthenticationException {
        OAuthCredentials oauthCredentials = (OAuthCredentials)credentials;
        logger.debug("credential : {}", (Object)oauthCredentials);
        String providerType = oauthCredentials.getCredential().getProviderType();
        logger.debug("providerType : {}", (Object)providerType);
        OAuthProvider provider = OAuthUtils.getProviderByType(this.configuration.getProviders(), providerType);
        logger.debug("provider : {}", (Object)provider);
        UserProfile userProfile = provider.getUserProfile(oauthCredentials.getCredential());
        logger.debug("userProfile : {}", (Object)userProfile);
        if (userProfile != null && StringUtils.isNotBlank((String)userProfile.getId())) {
            oauthCredentials.setUserProfile(userProfile);
            return true;
        }
        return false;
    }

    public void setConfiguration(OAuthConfiguration configuration) {
        this.configuration = configuration;
    }
}

