/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.ServicesManager;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20AuthorizeController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20AuthorizeController.class);
    private final String loginUrl;
    private final ServicesManager servicesManager;

    public OAuth20AuthorizeController(ServicesManager servicesManager, String loginUrl) {
        this.servicesManager = servicesManager;
        this.loginUrl = loginUrl;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String redirectUri = request.getParameter("redirect_uri");
        logger.debug("redirect_uri : {}", (Object)redirectUri);
        String clientId = request.getParameter("client_id");
        logger.debug("clientId : {}", (Object)clientId);
        String clientSecret = request.getParameter("client_secret");
        logger.debug("clientSecret : {}", (Object)clientSecret);
        if (StringUtils.isBlank((String)clientId)) {
            logger.error("missing clientId");
            return new ModelAndView("viewServiceErrorView");
        }
        if (StringUtils.isBlank((String)redirectUri)) {
            logger.error("missing redirectUri");
            return new ModelAndView("viewServiceErrorView");
        }
        Collection services = this.servicesManager.getAllServices();
        RegisteredService service = null;
        for (RegisteredService aService : services) {
            if (!StringUtils.equals((String)aService.getName(), (String)clientId)) continue;
            service = aService;
            break;
        }
        if (service == null) {
            logger.error("Unknown clientId : {}", (Object)clientId);
            return new ModelAndView("viewServiceErrorView");
        }
        String serviceId = service.getServiceId();
        if (!StringUtils.startsWith((String)redirectUri, (String)serviceId)) {
            logger.error("Unsupported redirectUri : {} for serviceId : {}", (Object)redirectUri, (Object)serviceId);
            return new ModelAndView("viewServiceErrorView");
        }
        HttpSession session = request.getSession();
        session.setAttribute("oauth20_callbackUrl", (Object)redirectUri);
        session.setAttribute("oauth20_service_name", (Object)service.getTheme());
        String callbackAuthorizeUrl = request.getRequestURL().toString().replace("/authorize", "/callbackAuthorize");
        logger.debug("callbackAuthorizeUrl : {}", (Object)callbackAuthorizeUrl);
        String loginUrlWithService = OAuthUtils.addParameter(this.loginUrl, "service", callbackAuthorizeUrl);
        logger.debug("loginUrlWithService : {}", (Object)loginUrlWithService);
        return OAuthUtils.redirectTo(loginUrlWithService);
    }
}

