/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20CallbackAuthorizeController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20CallbackAuthorizeController.class);

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket = request.getParameter("ticket");
        logger.debug("ticket : {}", (Object)ticket);
        HttpSession session = request.getSession();
        String callbackUrl = (String)session.getAttribute("oauth20_callbackUrl");
        logger.debug("callbackUrl : {}", (Object)callbackUrl);
        session.removeAttribute("oauth20_callbackUrl");
        String callbackUrlWithCode = OAuthUtils.addParameter(callbackUrl, "code", ticket);
        logger.debug("callbackUrlWithCode : {}", (Object)callbackUrlWithCode);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("callbackUrlWithCode", callbackUrlWithCode);
        String serviceName = (String)session.getAttribute("oauth20_service_name");
        model.put("serviceName", serviceName);
        return new ModelAndView("oauthConfirmView", model);
    }
}

