/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.ticket.TicketGrantingTicketImpl;
import org.jasig.cas.ticket.registry.TicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20ProfileController
extends AbstractController {
    private static final Logger logger = LoggerFactory.getLogger(OAuth20ProfileController.class);
    private final TicketRegistry ticketRegistry;

    public OAuth20ProfileController(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String accessToken = request.getParameter("access_token");
        logger.debug("accessToken : {}", (Object)accessToken);
        JsonFactory jsonFactory = new JsonFactory();
        JsonGenerator jsonGenerator = jsonFactory.createJsonGenerator((Writer)response.getWriter());
        if (StringUtils.isBlank((String)accessToken)) {
            logger.error("missing accessToken");
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("error", "missing_accessToken");
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            response.flushBuffer();
            return null;
        }
        TicketGrantingTicketImpl ticketGrantingTicketImpl = (TicketGrantingTicketImpl)this.ticketRegistry.getTicket(accessToken);
        if (ticketGrantingTicketImpl == null || ticketGrantingTicketImpl.isExpired()) {
            logger.error("expired accessToken : {}", (Object)accessToken);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("error", "expired_accessToken");
            jsonGenerator.writeEndObject();
            jsonGenerator.close();
            response.flushBuffer();
            return null;
        }
        Principal principal = ticketGrantingTicketImpl.getAuthentication().getPrincipal();
        jsonGenerator.writeStartObject();
        jsonGenerator.writeStringField("id", principal.getId());
        jsonGenerator.writeArrayFieldStart("attributes");
        Map attributes = principal.getAttributes();
        for (String key : attributes.keySet()) {
            jsonGenerator.writeStartObject();
            jsonGenerator.writeObjectField(key, attributes.get(key));
            jsonGenerator.writeEndObject();
        }
        jsonGenerator.writeEndArray();
        jsonGenerator.writeEndObject();
        jsonGenerator.close();
        response.flushBuffer();
        return null;
    }
}

