/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.web;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.support.oauth.OAuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;

public final class OAuth20CallbackAuthorizeController
extends AbstractController {
    private final Logger log = LoggerFactory.getLogger(OAuth20CallbackAuthorizeController.class);

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String ticket = request.getParameter("ticket");
        this.log.debug("ticket : {}", (Object)ticket);
        HttpSession session = request.getSession();
        String callbackUrl = (String)session.getAttribute("oauth20_callbackUrl");
        this.log.debug("callbackUrl : {}", (Object)callbackUrl);
        session.removeAttribute("oauth20_callbackUrl");
        String state = (String)session.getAttribute("oauth20_state");
        this.log.debug("state : {}", (Object)state);
        session.removeAttribute("oauth20_state");
        callbackUrl = OAuthUtils.addParameter(callbackUrl, "code", ticket);
        if (state != null) {
            callbackUrl = OAuthUtils.addParameter(callbackUrl, "state", state);
        }
        this.log.debug("callbackUrl : {}", (Object)callbackUrl);
        HashMap<String, String> model = new HashMap<String, String>();
        model.put("callbackUrl", callbackUrl);
        String serviceName = (String)session.getAttribute("oauth20_service_name");
        this.log.debug("serviceName : {}", (Object)serviceName);
        model.put("serviceName", serviceName);
        return new ModelAndView("oauthConfirmView", model);
    }
}

