/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.oauth.services;

import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jasig.cas.services.AbstractRegisteredService;
import org.jasig.cas.services.RegexRegisteredService;
import org.jasig.cas.services.RegisteredService;

@Entity
@DiscriminatorValue(value="oauth")
public final class OAuthRegisteredService
extends RegexRegisteredService {
    private static final long serialVersionUID = 5318897374067731021L;
    @Column(length=255, updatable=true, insertable=true)
    private String clientSecret;
    @Column(length=255, updatable=true, insertable=true)
    private String clientId;
    @Column(length=255, updatable=true, insertable=true)
    private Boolean bypassApprovalPrompt = Boolean.FALSE;

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public Boolean isBypassApprovalPrompt() {
        return this.bypassApprovalPrompt;
    }

    public void setBypassApprovalPrompt(Boolean bypassApprovalPrompt) {
        this.bypassApprovalPrompt = bypassApprovalPrompt;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.appendSuper(super.toString());
        builder.append("clientId", (Object)this.getClientId());
        builder.append("approvalPrompt", (Object)this.isBypassApprovalPrompt());
        return builder.toString();
    }

    public void copyFrom(RegisteredService source) {
        super.copyFrom(source);
        OAuthRegisteredService oAuthRegisteredService = (OAuthRegisteredService)source;
        this.setClientId(oAuthRegisteredService.getClientId());
        this.setClientSecret(oAuthRegisteredService.getClientSecret());
        this.setBypassApprovalPrompt(oAuthRegisteredService.isBypassApprovalPrompt());
    }

    protected AbstractRegisteredService newInstance() {
        return new OAuthRegisteredService();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        OAuthRegisteredService rhs = (OAuthRegisteredService)((Object)obj);
        return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.clientSecret, (Object)rhs.clientSecret).append((Object)this.clientId, (Object)rhs.clientId).append((Object)this.bypassApprovalPrompt, (Object)rhs.bypassApprovalPrompt).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.clientSecret).append((Object)this.clientId).append((Object)this.bypassApprovalPrompt).toHashCode();
    }
}

