/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.List;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;

public class RadiusAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    @Size(min=1)
    private List<RadiusServer> servers;
    private boolean failoverOnException;
    private boolean failoverOnAuthenticationFailure;

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String username = credential.getUsername();
        for (RadiusServer radiusServer : this.servers) {
            this.logger.debug("Attempting to authenticate {} at {}", (Object)username, (Object)radiusServer);
            try {
                if (radiusServer.authenticate(username, credential.getPassword())) {
                    return this.createHandlerResult((Credential)credential, (Principal)new SimplePrincipal(username), null);
                }
                if (!this.failoverOnAuthenticationFailure) {
                    throw new FailedLoginException();
                }
                this.logger.debug("failoverOnAuthenticationFailure enabled -- trying next server");
            }
            catch (PreventedException e) {
                if (!this.failoverOnException) {
                    throw e;
                }
                this.logger.warn("failoverOnException enabled -- trying next server.", (Throwable)e);
            }
        }
        throw new FailedLoginException();
    }

    public final void setFailoverOnAuthenticationFailure(boolean failoverOnAuthenticationFailure) {
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }

    public final void setFailoverOnException(boolean failoverOnException) {
        this.failoverOnException = failoverOnException;
    }

    public final void setServers(List<RadiusServer> servers) {
        this.servers = servers;
    }
}

