/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.principal;

import java.util.Arrays;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.support.spnego.util.SpnegoConstants;
import org.springframework.util.Assert;

public final class SpnegoCredentials
implements Credentials {
    private static final long serialVersionUID = -4908976823931528L;
    private final byte[] initToken;
    private byte[] nextToken;
    private Principal principal;
    private boolean isNtlm;

    public SpnegoCredentials(byte[] initToken) {
        Assert.notNull((Object)initToken, (String)"The initToken cannot be null.");
        this.initToken = initToken;
        this.isNtlm = this.isTokenNtlm(this.initToken);
    }

    public byte[] getInitToken() {
        return this.initToken;
    }

    public byte[] getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(byte[] nextToken) {
        this.nextToken = nextToken;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public boolean isNtlm() {
        return this.isNtlm;
    }

    private boolean isTokenNtlm(byte[] token) {
        if (token == null || token.length < 8) {
            return false;
        }
        int i = 0;
        while (i < 8) {
            if (SpnegoConstants.NTLMSSP_SIGNATURE[i] != token[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return this.principal != null ? this.principal.getId() : "Principal is null";
    }

    public boolean equals(Object obj) {
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        SpnegoCredentials c = (SpnegoCredentials)obj;
        return Arrays.equals(this.initToken, c.getInitToken()) && this.principal.equals(c.getPrincipal()) && Arrays.equals(this.nextToken, c.getNextToken());
    }

    public int hashCode() {
        return this.initToken.hashCode() ^ this.nextToken.hashCode() ^ this.principal.hashCode();
    }
}

