/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpnegoNegociateCredentialsAction
extends AbstractAction {
    private boolean ntlm = false;
    private List<String> supportedBrowser;
    private String messageBeginPrefix = this.constructMessagePrefix();

    protected Event doExecute(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        String userAgent = request.getHeader("User-Agent");
        if (StringUtils.hasText((String)userAgent) && this.isSupportedBrowser(userAgent) && (!StringUtils.hasText((String)authorizationHeader) || !authorizationHeader.startsWith(this.messageBeginPrefix) || authorizationHeader.length() <= this.messageBeginPrefix.length())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Authorization header not found. Sending WWW-Authenticate header");
            }
            response.setHeader("WWW-Authenticate", this.ntlm ? "NTLM" : "Negotiate");
            response.setStatus(401);
        }
        return this.success();
    }

    public void setNtlm(boolean ntlm) {
        this.ntlm = ntlm;
        this.messageBeginPrefix = this.constructMessagePrefix();
    }

    public void setSupportedBrowser(List<String> supportedBrowser) {
        this.supportedBrowser = supportedBrowser;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.supportedBrowser == null) {
            this.supportedBrowser = new ArrayList<String>();
            this.supportedBrowser.add("MSIE");
            this.supportedBrowser.add("Firefox");
            this.supportedBrowser.add("AppleWebKit");
        }
    }

    protected String constructMessagePrefix() {
        return String.valueOf(this.ntlm ? "NTLM" : "Negotiate") + " ";
    }

    protected boolean isSupportedBrowser(String userAgent) {
        for (String supportedBrowser : this.supportedBrowser) {
            if (!userAgent.contains(supportedBrowser)) continue;
            return true;
        }
        return false;
    }
}

