/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.regex.Pattern;
import javax.security.auth.login.FailedLoginException;
import jcifs.spnego.Authentication;
import jcifs.spnego.AuthenticationException;
import org.jasig.cas.authentication.AuthenticationHandler;
import org.jasig.cas.authentication.BasicCredentialMetaData;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.CredentialMetaData;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.handler.support.AbstractPreAndPostProcessingAuthenticationHandler;
import org.jasig.cas.authentication.principal.Principal;
import org.jasig.cas.authentication.principal.SimplePrincipal;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;

public final class JCIFSSpnegoAuthenticationHandler
extends AbstractPreAndPostProcessingAuthenticationHandler {
    private Authentication authentication;
    private boolean principalWithDomainName = true;
    private boolean isNTLMallowed = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HandlerResult doAuthentication(Credential credential) throws GeneralSecurityException, PreventedException {
        byte[] nextToken;
        java.security.Principal principal;
        SpnegoCredential spnegoCredential = (SpnegoCredential)credential;
        try {
            JCIFSSpnegoAuthenticationHandler jCIFSSpnegoAuthenticationHandler = this;
            synchronized (jCIFSSpnegoAuthenticationHandler) {
                this.authentication.reset();
                this.authentication.process(spnegoCredential.getInitToken());
                principal = this.authentication.getPrincipal();
                nextToken = this.authentication.getNextToken();
            }
        }
        catch (AuthenticationException e) {
            throw new FailedLoginException(e.getMessage());
        }
        if (nextToken != null) {
            this.logger.debug("Setting nextToken in credential");
            spnegoCredential.setNextToken(nextToken);
        } else {
            this.logger.debug("nextToken is null");
        }
        boolean success = false;
        if (principal != null) {
            if (spnegoCredential.isNtlm()) {
                this.logger.debug("NTLM Credential is valid for user [{}]", (Object)principal.getName());
                spnegoCredential.setPrincipal((Principal)this.getSimplePrincipal(principal.getName(), true));
                success = this.isNTLMallowed;
            }
            this.logger.debug("Kerberos Credential is valid for user [{}]", (Object)principal.getName());
            spnegoCredential.setPrincipal((Principal)this.getSimplePrincipal(principal.getName(), false));
            success = true;
        }
        if (!success) {
            throw new FailedLoginException("Principal is null, the processing of the SPNEGO Token failed");
        }
        return new HandlerResult((AuthenticationHandler)this, (CredentialMetaData)new BasicCredentialMetaData(credential), spnegoCredential.getPrincipal());
    }

    public boolean supports(Credential credential) {
        return credential instanceof SpnegoCredential;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public void setPrincipalWithDomainName(boolean principalWithDomainName) {
        this.principalWithDomainName = principalWithDomainName;
    }

    public void setNTLMallowed(boolean isNTLMallowed) {
        this.isNTLMallowed = isNTLMallowed;
    }

    protected SimplePrincipal getSimplePrincipal(String name, boolean isNtlm) {
        if (this.principalWithDomainName) {
            return new SimplePrincipal(name);
        }
        if (isNtlm) {
            return Pattern.matches("\\S+\\\\\\S+", name) ? new SimplePrincipal(name.split("\\\\")[1]) : new SimplePrincipal(name);
        }
        return new SimplePrincipal(name.split("@")[0]);
    }
}

