/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.authentication.principal;

import java.util.Locale;
import javax.validation.constraints.NotNull;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.principal.PersonDirectoryPrincipalResolver;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;

public final class SpnegoPrincipalResolver
extends PersonDirectoryPrincipalResolver {
    @NotNull
    private Transform transformPrincipalId = Transform.NONE;

    protected String extractPrincipalId(Credential credential) {
        SpnegoCredential c = (SpnegoCredential)credential;
        switch (this.transformPrincipalId) {
            case UPPERCASE: {
                return c.getPrincipal().getId().toUpperCase(Locale.ENGLISH);
            }
            case LOWERCASE: {
                return c.getPrincipal().getId().toLowerCase(Locale.ENGLISH);
            }
        }
        return c.getPrincipal().getId();
    }

    public boolean supports(Credential credential) {
        return credential != null && SpnegoCredential.class.equals(credential.getClass());
    }

    public void setTransformPrincipalId(Transform transform) {
        this.transformPrincipalId = transform;
    }

    public static enum Transform {
        NONE,
        UPPERCASE,
        LOWERCASE;

    }
}

