/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.support.spnego.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jcifs.util.Base64;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.support.spnego.authentication.principal.SpnegoCredential;
import org.jasig.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.execution.RequestContext;

public final class SpnegoCredentialsAction
extends AbstractNonInteractiveCredentialsAction {
    private boolean ntlm = false;
    private String messageBeginPrefix = this.constructMessagePrefix();
    private boolean send401OnAuthenticationFailure = true;

    protected Credential constructCredentialsFromRequest(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)context);
        String authorizationHeader = request.getHeader("Authorization");
        if (StringUtils.hasText((String)authorizationHeader) && authorizationHeader.startsWith(this.messageBeginPrefix) && authorizationHeader.length() > this.messageBeginPrefix.length()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("SPNEGO Authorization header found with " + (authorizationHeader.length() - this.messageBeginPrefix.length()) + " bytes"));
            }
            byte[] token = Base64.decode((String)authorizationHeader.substring(this.messageBeginPrefix.length()));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Obtained token: " + new String(token)));
            }
            return new SpnegoCredential(token);
        }
        return null;
    }

    protected String constructMessagePrefix() {
        return (this.ntlm ? "NTLM" : "Negotiate") + " ";
    }

    protected void onError(RequestContext context, Credential credential) {
        this.setResponseHeader(context, credential);
    }

    protected void onSuccess(RequestContext context, Credential credential) {
        this.setResponseHeader(context, credential);
    }

    private void setResponseHeader(RequestContext context, Credential credential) {
        if (credential == null) {
            return;
        }
        HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)context);
        SpnegoCredential spnegoCredentials = (SpnegoCredential)credential;
        byte[] nextToken = spnegoCredentials.getNextToken();
        if (nextToken != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Obtained output token: " + new String(nextToken)));
            }
            response.setHeader("WWW-Authenticate", (this.ntlm ? "NTLM" : "Negotiate") + " " + Base64.encode((byte[])nextToken));
        } else {
            this.logger.debug((Object)"Unable to obtain the output token required.");
        }
        if (spnegoCredentials.getPrincipal() == null && this.send401OnAuthenticationFailure) {
            this.logger.debug((Object)"Setting HTTP Status to 401");
            response.setStatus(401);
        }
    }

    public void setNtlm(boolean ntlm) {
        this.ntlm = ntlm;
        this.messageBeginPrefix = this.constructMessagePrefix();
    }

    public void setSend401OnAuthenticationFailure(boolean send401OnAuthenticationFailure) {
        this.send401OnAuthenticationFailure = send401OnAuthenticationFailure;
    }
}

