/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.x509.authentication.handler.support;

import edu.vt.middleware.crypt.x509.ExtensionReader;
import edu.vt.middleware.crypt.x509.types.DistributionPoint;
import edu.vt.middleware.crypt.x509.types.DistributionPointList;
import edu.vt.middleware.crypt.x509.types.GeneralName;
import edu.vt.middleware.crypt.x509.types.GeneralNameList;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.jasig.cas.adaptors.x509.authentication.handler.support.AbstractCRLRevocationChecker;
import org.jasig.cas.adaptors.x509.util.CertUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CRLDistributionPointRevocationChecker
extends AbstractCRLRevocationChecker {
    private Cache crlCache;

    public CRLDistributionPointRevocationChecker(Cache crlCache) {
        if (crlCache == null) {
            throw new IllegalArgumentException("Cache cannot be null.");
        }
        this.crlCache = crlCache;
    }

    @Override
    protected X509CRL getCRL(X509Certificate cert) {
        URL[] urls = this.getDistributionPoints(cert);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("Distribution points for %s: %s.", CertUtils.toString(cert), Arrays.asList(urls)));
        }
        URL[] uRLArray = urls;
        int n = urls.length;
        int n2 = 0;
        while (n2 < n) {
            URL url = uRLArray[n2];
            Element item = this.crlCache.get((Serializable)url);
            if (item != null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Found CRL in cache for " + CertUtils.toString(cert)));
                }
                return (X509CRL)item.getObjectValue();
            }
            ++n2;
        }
        X509CRL crl = null;
        int i = 0;
        while (i < urls.length && crl == null) {
            this.log.info((Object)("Attempting to fetch CRL at " + urls[i]));
            try {
                crl = CertUtils.fetchCRL((Resource)new UrlResource(urls[i]));
                this.log.info((Object)"Success. Caching fetched CRL.");
                this.crlCache.put(new Element((Object)urls[i], (Object)crl));
            }
            catch (Exception e) {
                this.log.error((Object)("Error fetching CRL at " + urls[i]), (Throwable)e);
            }
            ++i;
        }
        return crl;
    }

    private URL[] getDistributionPoints(X509Certificate cert) {
        DistributionPointList points;
        try {
            points = new ExtensionReader(cert).readCRLDistributionPoints();
        }
        catch (Exception e) {
            this.log.error((Object)("Error reading CRLDistributionPoints extension field on " + CertUtils.toString(cert)), (Throwable)e);
            return new URL[0];
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        DistributionPoint[] distributionPointArray = (DistributionPoint[])points.getItems();
        int n = distributionPointArray.length;
        int n2 = 0;
        while (n2 < n) {
            DistributionPoint point = distributionPointArray[n2];
            Object location = point.getDistributionPoint();
            if (location instanceof String) {
                this.addURL(urls, (String)location);
            } else if (location instanceof GeneralNameList) {
                GeneralName[] generalNameArray = (GeneralName[])((GeneralNameList)location).getItems();
                int n3 = generalNameArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    GeneralName gn = generalNameArray[n4];
                    this.addURL(urls, gn.getName());
                    ++n4;
                }
            } else {
                this.log.warn((Object)(location + " not supported.  String or GeneralNameList expected."));
            }
            ++n2;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void addURL(List<URL> list, String uriString) {
        try {
            URL url = new URL(uriString);
            URI uri = new URI(url.getProtocol(), url.getAuthority(), url.getPath(), url.getQuery(), null);
            list.add(uri.toURL());
        }
        catch (Exception exception) {
            this.log.warn((Object)(String.valueOf(uriString) + " is not a valid distribution point URI."));
        }
    }
}

