/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web;

import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.jasig.cas.CentralAuthenticationService;
import org.jasig.cas.authentication.AuthenticationException;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HttpBasedServiceCredential;
import org.jasig.cas.authentication.principal.Service;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.services.UnauthorizedProxyingException;
import org.jasig.cas.services.UnauthorizedServiceException;
import org.jasig.cas.ticket.TicketException;
import org.jasig.cas.ticket.TicketValidationException;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.validation.Assertion;
import org.jasig.cas.validation.Cas20ProtocolValidationSpecification;
import org.jasig.cas.validation.ValidationSpecification;
import org.jasig.cas.web.DelegateController;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.servlet.ModelAndView;

public class ServiceValidateController
extends DelegateController {
    public static final String DEFAULT_SERVICE_FAILURE_VIEW_NAME = "cas2ServiceFailureView";
    public static final String DEFAULT_SERVICE_SUCCESS_VIEW_NAME = "cas2ServiceSuccessView";
    private static final String MODEL_PROXY_GRANTING_TICKET_IOU = "pgtIou";
    private static final String MODEL_ASSERTION = "assertion";
    private static final String PARAMETER_PROXY_CALLBACK_URL = "pgtUrl";
    @NotNull
    private CentralAuthenticationService centralAuthenticationService;
    @NotNull
    private Class<?> validationSpecificationClass = Cas20ProtocolValidationSpecification.class;
    @NotNull
    private ProxyHandler proxyHandler;
    @NotNull
    private String successView = "cas2ServiceSuccessView";
    @NotNull
    private String failureView = "cas2ServiceFailureView";
    @NotNull
    private ArgumentExtractor argumentExtractor;

    protected Credential getServiceCredentialsFromRequest(HttpServletRequest request) {
        String pgtUrl = request.getParameter(PARAMETER_PROXY_CALLBACK_URL);
        if (StringUtils.hasText((String)pgtUrl)) {
            try {
                return new HttpBasedServiceCredential(new URL(pgtUrl));
            }
            catch (Exception e) {
                this.logger.error("Error constructing pgtUrl", (Throwable)e);
            }
        }
        return null;
    }

    protected void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) {
        binder.setRequiredFields(new String[]{"renew"});
    }

    protected final ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String serviceTicketId;
        WebApplicationService service = this.argumentExtractor.extractService(request);
        String string = serviceTicketId = service != null ? service.getArtifactId() : null;
        if (service == null || serviceTicketId == null) {
            this.logger.debug("Could not identify service and/or service ticket. Service: {}, Service ticket id: {}", (Object)service, (Object)serviceTicketId);
            return this.generateErrorView("INVALID_REQUEST", "INVALID_REQUEST", null);
        }
        try {
            Credential serviceCredential = this.getServiceCredentialsFromRequest(request);
            String proxyGrantingTicketId = null;
            if (serviceCredential != null) {
                try {
                    proxyGrantingTicketId = this.centralAuthenticationService.delegateTicketGrantingTicket(serviceTicketId, new Credential[]{serviceCredential});
                }
                catch (AuthenticationException authenticationException) {
                    this.logger.info("Failed to authenticate service credential {}", (Object)serviceCredential);
                }
                catch (TicketException e) {
                    this.logger.error("Failed to create proxy granting ticket for {}", (Object)serviceCredential, (Object)e);
                }
                if (StringUtils.isEmpty(proxyGrantingTicketId)) {
                    return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()});
                }
            }
            Assertion assertion = this.centralAuthenticationService.validateServiceTicket(serviceTicketId, (Service)service);
            ValidationSpecification validationSpecification = this.getCommandClass();
            ServletRequestDataBinder binder = new ServletRequestDataBinder((Object)validationSpecification, "validationSpecification");
            this.initBinder(request, binder);
            binder.bind((ServletRequest)request);
            if (!validationSpecification.isSatisfiedBy(assertion)) {
                this.logger.debug("Service ticket [{}] does not satisfy validation specification.", (Object)serviceTicketId);
                return this.generateErrorView("INVALID_TICKET", "INVALID_TICKET_SPEC", null);
            }
            String proxyIou = null;
            if (serviceCredential != null && proxyGrantingTicketId != null && this.proxyHandler.canHandle(serviceCredential) && StringUtils.isEmpty((Object)(proxyIou = this.proxyHandler.handle(serviceCredential, proxyGrantingTicketId)))) {
                return this.generateErrorView("INVALID_PROXY_CALLBACK", "INVALID_PROXY_CALLBACK", new Object[]{serviceCredential.getId()});
            }
            this.onSuccessfulValidation(serviceTicketId, assertion);
            this.logger.debug("Successfully validated service ticket {} for service [{}]", (Object)serviceTicketId, (Object)service.getId());
            return this.generateSuccessView(assertion, proxyIou);
        }
        catch (TicketValidationException e) {
            return this.generateErrorView(e.getCode(), e.getCode(), new Object[]{serviceTicketId, e.getOriginalService().getId(), service.getId()});
        }
        catch (TicketException te) {
            return this.generateErrorView(te.getCode(), te.getCode(), new Object[]{serviceTicketId});
        }
        catch (UnauthorizedProxyingException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), new Object[]{service.getId()});
        }
        catch (UnauthorizedServiceException e) {
            return this.generateErrorView(e.getMessage(), e.getMessage(), null);
        }
    }

    protected void onSuccessfulValidation(String serviceTicketId, Assertion assertion) {
    }

    private ModelAndView generateErrorView(String code, String description, Object[] args) {
        ModelAndView modelAndView = new ModelAndView(this.failureView);
        String convertedDescription = this.getMessageSourceAccessor().getMessage(description, args, description);
        modelAndView.addObject("code", (Object)code);
        modelAndView.addObject("description", (Object)convertedDescription);
        return modelAndView;
    }

    private ModelAndView generateSuccessView(Assertion assertion, String proxyIou) {
        ModelAndView success = new ModelAndView(this.successView);
        success.addObject(MODEL_ASSERTION, (Object)assertion);
        success.addObject(MODEL_PROXY_GRANTING_TICKET_IOU, (Object)proxyIou);
        return success;
    }

    private ValidationSpecification getCommandClass() {
        try {
            return (ValidationSpecification)this.validationSpecificationClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean canHandle(HttpServletRequest request, HttpServletResponse response) {
        return true;
    }

    public final void setCentralAuthenticationService(CentralAuthenticationService centralAuthenticationService) {
        this.centralAuthenticationService = centralAuthenticationService;
    }

    public final void setArgumentExtractor(ArgumentExtractor argumentExtractor) {
        this.argumentExtractor = argumentExtractor;
    }

    public final void setValidationSpecificationClass(Class<?> validationSpecificationClass) {
        this.validationSpecificationClass = validationSpecificationClass;
    }

    public final void setFailureView(String failureView) {
        this.failureView = failureView;
    }

    public final void setSuccessView(String successView) {
        this.successView = successView;
    }

    public final void setProxyHandler(ProxyHandler proxyHandler) {
        this.proxyHandler = proxyHandler;
    }
}

