/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.Collections;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.springframework.util.Assert;
import org.springframework.webflow.mvc.servlet.FlowHandler;
import org.springframework.webflow.mvc.servlet.FlowHandlerAdapter;

public class SelectiveFlowHandlerAdapter
extends FlowHandlerAdapter {
    @NotNull
    private Set<String> supportedFlowIds;

    public void setSupportedFlowIds(Set<String> flowIdSet) {
        this.supportedFlowIds = flowIdSet;
    }

    public void setSupportedFlowId(String flowId) {
        this.supportedFlowIds = Collections.singleton(flowId);
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        Assert.isTrue((!this.supportedFlowIds.isEmpty() ? 1 : 0) != 0, (String)"Must specify at least one supported flow ID");
    }

    public boolean supports(Object handler) {
        return handler instanceof FlowHandler && this.supportedFlowIds.contains(((FlowHandler)handler).getFlowId());
    }
}

