/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.jboss.authentication;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.jaas.AssertionPrincipal;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jboss.web.tomcat.security.login.WebAuthentication;

public final class WebAuthenticationFilter
extends AbstractCasFilter {
    public WebAuthenticationFilter() {
        super(Protocol.CAS2);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession();
        String ticket = CommonUtils.safeGetParameter((HttpServletRequest)request, (String)this.getProtocol().getArtifactParameterName());
        if (session != null && session.getAttribute("_const_cas_assertion_") == null && ticket != null) {
            try {
                String service = this.constructServiceUrl(request, response);
                this.logger.debug("Attempting CAS ticket validation with service={} and ticket={}", (Object)service, (Object)ticket);
                if (!new WebAuthentication().login(service, (Object)ticket)) {
                    this.logger.debug("JBoss Web authentication failed.");
                    throw new GeneralSecurityException("JBoss Web authentication failed.");
                }
                if (!(request.getUserPrincipal() instanceof AssertionPrincipal)) {
                    this.logger.debug("Aborting -- principal is not of type AssertionPrincipal");
                    throw new GeneralSecurityException("JBoss Web authentication did not produce CAS AssertionPrincipal.");
                }
                AssertionPrincipal principal = (AssertionPrincipal)request.getUserPrincipal();
                this.logger.debug("Installing CAS assertion into session.");
                request.getSession().setAttribute("_const_cas_assertion_", (Object)principal.getAssertion());
            }
            catch (GeneralSecurityException e) {
                response.sendError(403, e.getMessage());
            }
        } else if (session != null && request.getUserPrincipal() == null) {
            this.logger.info("User principal not found.  Removing CAS assertion from session to force re-authentication.");
            session.removeAttribute("_const_cas_assertion_");
        }
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

