/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.i18n.translate;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.memetix.mst.MicrosoftTranslatorAPI;
import com.memetix.mst.language.Language;
import com.memetix.mst.translate.Translate;

public class BingAutoTranslationService {

    protected final Log log = LogFactory.getLog(getClass());
    private String      clientId;

    private String      clientSecret;

    public Map<String, String> getAutoUpdatedTranslationMap(final Map<String, String> mainMap, final Map<String, String> targetMap,
            final String languageKey) throws Exception {

        final Set<String> missing = mainMap.keySet();
        missing.removeAll(targetMap.keySet());

        final List<String> keys = new ArrayList<String>();
        keys.addAll(missing);

        MicrosoftTranslatorAPI.setClientId(this.clientId);
        MicrosoftTranslatorAPI.setClientSecret(this.clientSecret);

        final Locale loc = new Locale(languageKey);
        final String langName = loc.getDisplayLanguage().toUpperCase(loc);

        try {
            final Language lang = Language.valueOf(langName);

            for (final String key : keys) {
                final String msg = mainMap.get(key);

                this.log.info("Translating message key " + key + " for language file " + languageKey);
                final String translation = Translate.execute(msg, lang);

                targetMap.put(key, translation);
            }

        } catch (final IllegalArgumentException ex) {
            this.log.warn("Language " + langName + " is currently unsupported.");
        }
        return targetMap;
    }

    public void setClientId(final String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(final String sec) {
        this.clientSecret = sec;
    }
}
