/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.i18n.translate;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.jasig.i18n.translate.BingAutoTranslationService;
import org.jasig.i18n.translate.LanguageFile;
import org.jasig.i18n.translate.MessageFileService;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class AutoTranslateMojo
extends AbstractMojo {
    private BingAutoTranslationService translationService;
    private MessageFileService messageFileService;
    private String clientId;
    private String clientSecret;
    private String messagesDirectory;
    private String mainMessagesFile;
    private final List<String> languageKeys = Arrays.asList("de");
    private String messageFilePattern;

    public void execute() throws MojoExecutionException {
        try {
            this.translationService = new BingAutoTranslationService();
            this.translationService.setClientId(this.clientId);
            this.translationService.setClientSecret(this.clientSecret);
            this.messageFileService = new MessageFileService();
            Set<String> mainKeys = null;
            this.getLog().info((CharSequence)("Locating main messages file at " + this.getMainMessagesFile()));
            FileSystemResource resource = new FileSystemResource(this.getMainMessagesFile());
            mainKeys = this.messageFileService.getMessageKeysFromFile((Resource)resource);
            for (String key : this.languageKeys) {
                String fileName = String.format(this.messageFilePattern, key);
                LanguageFile file = new LanguageFile(this.messagesDirectory, fileName, key);
                if (file.exists() && file.canRead()) {
                    FileSystemResource resource2 = new FileSystemResource((File)file);
                    Set<String> targetKeys = this.messageFileService.getMessageKeysFromFile((Resource)resource2);
                    HashSet<String> missingKeys = new HashSet<String>();
                    missingKeys.addAll(mainKeys);
                    missingKeys.removeAll(targetKeys);
                    if (missingKeys.size() <= 0) continue;
                    this.getLog().info((CharSequence)("Translating message file at " + file.getCanonicalPath()));
                    FileSystemResource languageFile = new FileSystemResource((File)file);
                    Map<String, String> targetMap = this.messageFileService.getMessageMapFromFile((Resource)languageFile);
                    Map<String, String> mainMap = this.messageFileService.getMessageMapFromFile((Resource)resource);
                    Map<String, String> updatedMap = this.translationService.getAutoUpdatedTranslationMap(mainMap, targetMap, key);
                    this.messageFileService.updateMessageFile((Resource)languageFile, updatedMap);
                    continue;
                }
                this.getLog().error((CharSequence)("Message file for language '" + key + "' (" + key + ") cannot be located"));
            }
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Main messages file could not be located.");
            throw new MojoExecutionException(ex.getMessage());
        }
        catch (Exception ex) {
            this.getLog().error((Throwable)ex);
            throw new MojoExecutionException(ex.getMessage());
        }
    }

    protected File getMainMessagesFile() {
        return new File(this.messagesDirectory, this.mainMessagesFile);
    }
}

