/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.i18n.translate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.i18n.translate.GoogleTranslationResponse;
import org.springframework.http.converter.json.MappingJacksonHttpMessageConverter;
import org.springframework.web.client.RestTemplate;

public class GoogleAutoTranslationService {
    protected final Log log = LogFactory.getLog(this.getClass());
    private final String urlTemplate = "https://www.googleapis.com/language/translate/v2?key={key}&source={source}&target={target}&q={query}";
    private String apiKey;
    private String defaultLanguageKey = "en";
    private final RestTemplate restTemplate = new RestTemplate();

    public GoogleAutoTranslationService() {
        List<MappingJacksonHttpMessageConverter> converters = Collections.singletonList(new MappingJacksonHttpMessageConverter());
        this.restTemplate.setMessageConverters(converters);
    }

    public Map<String, String> getAutoUpdatedTranslationMap(Map<String, String> mainMap, Map<String, String> targetMap, String languageKey) {
        Set<String> missing = mainMap.keySet();
        missing.removeAll(targetMap.keySet());
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(missing);
        ArrayList<String> untranslatedMessages = new ArrayList<String>();
        for (String key : keys) {
            untranslatedMessages.add(mainMap.get(key));
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("key", this.apiKey);
        parameters.put("source", this.defaultLanguageKey);
        parameters.put("target", languageKey);
        parameters.put("query", untranslatedMessages);
        GoogleTranslationResponse response = (GoogleTranslationResponse)this.restTemplate.getForObject(this.urlTemplate, GoogleTranslationResponse.class, parameters);
        List<GoogleTranslationResponse.Translation> translations = response.getTranslations();
        ListIterator<GoogleTranslationResponse.Translation> iter = translations.listIterator();
        while (iter.hasNext()) {
            GoogleTranslationResponse.Translation translation = iter.next();
            String key = (String)keys.get(iter.previousIndex());
            targetMap.put(key, translation.getTranslatedText());
        }
        return targetMap;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    public void setDefaultLanguageKey(String defaultLanguageKey) {
        this.defaultLanguageKey = defaultLanguageKey;
    }
}

