/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.i18n.translate;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.jasig.i18n.translate.LanguageFile;
import org.jasig.i18n.translate.MessageFileService;
import org.jasig.i18n.translate.MissingKeysException;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class ReportMissingKeysMojo
extends AbstractMojo {
    private String[] languageKeys;
    private String mainMessagesFile;
    private String messageFilePattern;
    private MessageFileService messageFileService;
    private String messagesDirectory;
    private final Map<LanguageFile, Set<String>> reportedPropertyFilesMap = new LinkedHashMap<LanguageFile, Set<String>>();
    private boolean warnOnly;

    public void execute() throws MojoExecutionException {
        Set<String> mainKeys = null;
        Map<String, String> mainMap = null;
        try {
            this.messageFileService = new MessageFileService();
            this.getLog().info((CharSequence)("Locating main messages file at " + this.getMainMessagesFile()));
            FileSystemResource resource = new FileSystemResource(this.getMainMessagesFile());
            mainMap = this.messageFileService.getMessageMapFromFile((Resource)resource);
            mainKeys = mainMap.keySet();
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)"Main messages file could not be located");
            throw new MojoExecutionException(ex.getMessage());
        }
        File msgDir = new File(this.messagesDirectory);
        if (!msgDir.exists()) {
            throw new MojoExecutionException("Main messages directory " + this.messagesDirectory + " does not exist.");
        }
        final Pattern pattern = Pattern.compile(this.messageFilePattern, 10);
        final HashMap keys = new HashMap();
        if (this.languageKeys.length == 0) {
            msgDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    boolean matches = false;
                    Matcher matcher = pattern.matcher(name);
                    if (matcher.find()) {
                        String langKey = matcher.group(1);
                        keys.put(langKey, name);
                        ReportMissingKeysMojo.this.getLog().info((CharSequence)("Added language file " + name + " to the processing queue."));
                        matches = true;
                    }
                    return matches;
                }
            });
        } else {
            Arrays.sort(this.languageKeys);
            msgDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    Matcher matcher;
                    boolean matches = false;
                    if (!name.equalsIgnoreCase(ReportMissingKeysMojo.this.mainMessagesFile) && (matcher = pattern.matcher(name)).find()) {
                        String langKey = matcher.group(1);
                        int idx = Arrays.binarySearch(ReportMissingKeysMojo.this.languageKeys, langKey);
                        if (idx >= 0) {
                            keys.put(langKey, name);
                            ReportMissingKeysMojo.this.getLog().info((CharSequence)("Added language file " + name + " to the processing queue."));
                            matches = true;
                        }
                    }
                    return matches;
                }
            });
        }
        Iterator itKeys = keys.keySet().iterator();
        while (itKeys.hasNext()) {
            try {
                String key = (String)itKeys.next();
                String fileName = (String)keys.get(key);
                LanguageFile file = new LanguageFile(this.messagesDirectory, fileName, key);
                if (file.exists() && file.canRead()) {
                    FileSystemResource resource2 = new FileSystemResource((File)file);
                    Map<String, String> map = this.messageFileService.getMessageMapFromFile((Resource)resource2);
                    Set<String> targetKeys = map.keySet();
                    HashSet<String> missingKeys = new HashSet<String>();
                    missingKeys.addAll(mainKeys);
                    missingKeys.removeAll(targetKeys);
                    if (missingKeys.size() <= 0) continue;
                    this.getLog().info((CharSequence)("Locating messages file at " + file.getCanonicalPath()));
                    this.getLog().warn((CharSequence)("Found " + missingKeys.size() + " missing keys for " + key + " in file " + file.getName() + ". Missing keys are:"));
                    for (String keyMissing : missingKeys) {
                        this.getLog().warn((CharSequence)("\t" + keyMissing + "=" + mainMap.get(keyMissing)));
                    }
                    this.getReportedPropertyFiles().put(file, missingKeys);
                    continue;
                }
                this.getLog().error((CharSequence)("Messages file for language '" + key + "' (" + key + ") cannot be located"));
            }
            catch (Exception ex) {
                throw new MojoExecutionException(ex.getMessage());
            }
        }
        this.reportFinalResults();
    }

    public String[] getLanguageKeys() {
        return this.languageKeys;
    }

    public Map<LanguageFile, Set<String>> getReportedPropertyFiles() {
        return this.reportedPropertyFilesMap;
    }

    public void setLanguageKeys(String[] languageKeys) {
        this.languageKeys = languageKeys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void reportFinalResults() throws MissingKeysException {
        if (this.getReportedPropertyFiles().size() == 0) {
            if (!this.warnOnly) throw new MissingKeysException("No language files were found at the specified messages directory: " + this.messagesDirectory);
            this.getLog().warn((CharSequence)("No language files were found at the specified messages directory: " + this.messagesDirectory));
            return;
        } else if (this.getReportedPropertyFiles().size() > 0) {
            if (!this.warnOnly) throw new MissingKeysException("Found " + this.getReportedPropertyFiles().size() + " property file(s) with missing keys.");
            this.getLog().warn((CharSequence)("Found " + this.getReportedPropertyFiles().size() + " property file(s) with missing keys."));
            return;
        } else {
            this.getLog().info((CharSequence)("Verified all language files for keys: " + Arrays.toString(this.languageKeys)));
        }
    }

    protected File getMainMessagesFile() {
        return new File(this.messagesDirectory, this.mainMessagesFile);
    }
}

