/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.jasig.maven.plugin.sass.CompilationErrors;
import org.jasig.maven.plugin.sass.Resource;

public abstract class AbstractSassMojo
extends AbstractMojo {
    protected List<Resource> resources;
    protected File buildDirectory;
    protected boolean failOnError;
    protected Map<String, String> sassOptions = new HashMap<String, String>((Map<String, String>)ImmutableMap.of((Object)"unix_newlines", (Object)"true", (Object)"cache", (Object)"true", (Object)"always_update", (Object)"true", (Object)"style", (Object)":expanded"));
    protected boolean useCompass;

    protected void buildBasicSASSScript(StringBuilder sassScript) throws MojoExecutionException {
        Log log = this.getLog();
        sassScript.append("require 'rubygems'\n");
        sassScript.append("require 'sass/plugin'\n");
        sassScript.append("require 'java'\n");
        if (this.useCompass) {
            log.info((CharSequence)"Running with Compass enabled.");
            sassScript.append("require 'compass'\n");
            sassScript.append("require 'compass/exec'\n");
            sassScript.append("Compass.add_project_configuration \n");
            this.sassOptions.put("load_paths", "Compass.configuration.sass_load_paths");
            sassScript.append("Compass::Frameworks.register_directory('jar:'+ File.join(Compass.base_directory, 'frameworks/compass'))\n");
            sassScript.append("Compass::Frameworks.register_directory('jar:'+ File.join(Compass.base_directory, 'frameworks/blueprint'))\n");
        }
        sassScript.append("Sass::Plugin.options.merge!(\n");
        if (!this.sassOptions.containsKey("cache_location")) {
            File sassCacheDir = new File(this.buildDirectory, "sass_cache");
            String sassCacheDirStr = sassCacheDir.toString();
            this.sassOptions.put("cache_location", "'" + FilenameUtils.separatorsToUnix((String)sassCacheDirStr) + "'");
        }
        Iterator<Map.Entry<String, String>> entryItr = this.sassOptions.entrySet().iterator();
        while (entryItr.hasNext()) {
            Map.Entry<String, String> optEntry = entryItr.next();
            String opt = optEntry.getKey();
            String value = optEntry.getValue();
            sassScript.append("    :").append(opt).append(" => ").append(value);
            if (entryItr.hasNext()) {
                sassScript.append(",");
            }
            sassScript.append("\n");
        }
        sassScript.append(")\n");
        sassScript.append("java_import ");
        sassScript.append(CompilationErrors.class.getName());
        sassScript.append("\n");
        sassScript.append("$compilation_errors = CompilationErrors.new\n");
        sassScript.append("Sass::Plugin.on_compilation_error {|error, template, css| $compilation_errors.add(template, error.message) }\n");
        for (Resource source : this.resources) {
            for (Map.Entry<String, String> entry : source.getDirectoriesAndDestinations().entrySet()) {
                log.info((CharSequence)("Queing SASS Template for compile: " + entry.getKey() + " => " + entry.getValue()));
                sassScript.append("Sass::Plugin.add_template_location('").append(entry.getKey()).append("', '").append(entry.getValue()).append("')\n");
            }
        }
        if (log.isDebugEnabled()) {
            sassScript.append("require 'pp'\npp Sass::Plugin.options\n");
            sassScript.append("pp Compass::configuration\n");
        }
    }
}

