/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.maven.plugin.sass;

import java.io.File;
import java.util.LinkedHashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.model.FileSet;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.StringUtils;

public class Resource {
    protected FileSet source;
    protected File destination;

    public LinkedHashMap<String, String> getDirectoriesAndDestinations() {
        String sourceDirectory = this.source.getDirectory();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(sourceDirectory);
        scanner.setIncludes(this.source.getIncludes().toArray(new String[this.source.getIncludes().size()]));
        scanner.setExcludes(this.source.getExcludes().toArray(new String[this.source.getExcludes().size()]));
        scanner.scan();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(FilenameUtils.separatorsToUnix((String)sourceDirectory), FilenameUtils.separatorsToUnix((String)this.destination.toString()));
        for (String included : scanner.getIncludedDirectories()) {
            if (included.isEmpty()) continue;
            String subdir = StringUtils.difference((String)sourceDirectory, (String)included);
            result.put(FilenameUtils.separatorsToUnix((String)(sourceDirectory + "/" + included)), FilenameUtils.separatorsToUnix((String)(this.destination.toString() + "/" + subdir)));
        }
        return result;
    }
}

