/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.jspc;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.mojo.jspc.CompilationMojoSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="compile", defaultPhase=LifecyclePhase.PROCESS_CLASSES, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class CompileMojo
extends CompilationMojoSupport {
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true)
    private List<String> classpathElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List<String> getClasspathElements() throws MojoExecutionException {
        ArrayList<String> list;
        block15: {
            File tempJarDir;
            list = new ArrayList<String>(this.classpathElements.size());
            boolean tldExists = false;
            String[] tlds = new String[]{"tld"};
            try {
                tempJarDir = File.createTempFile("jscp-", "");
            }
            catch (IOException e) {
                throw new MojoExecutionException("Failed to create jscp temp dir", (Exception)e);
            }
            try {
                File tempJarFile;
                tempJarDir.delete();
                tempJarDir.mkdir();
                for (String target : this.classpathElements) {
                    File file = new File(target);
                    if (file.isFile()) {
                        list.add(target);
                        continue;
                    }
                    if (!file.isDirectory()) continue;
                    Collection tldFiles = FileUtils.listFiles((File)file, (String[])tlds, (boolean)true);
                    if (!tldFiles.isEmpty()) {
                        try {
                            FileUtils.copyDirectory((File)file, (File)tempJarDir);
                        }
                        catch (IOException e) {
                            throw new MojoExecutionException("Failed copy '" + file + "' to '" + tempJarDir + "'", (Exception)e);
                        }
                        tldExists = true;
                        continue;
                    }
                    list.add(target);
                }
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("tldExists: " + tldExists));
                }
                if (!tldExists) break block15;
                try {
                    tempJarFile = File.createTempFile("jscptld-", ".jar");
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed to create jscptld temp file", (Exception)e);
                }
                tempJarFile.deleteOnExit();
                try {
                    this.createJarArchive(tempJarFile, tempJarDir);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Failed create jar '" + tempJarFile + "' from '" + tempJarFile + "'", (Exception)e);
                }
                list.add(tempJarFile.getAbsolutePath());
            }
            finally {
                FileUtils.deleteQuietly((File)tempJarDir);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createJarArchive(File archiveFile, File tempJarDir) throws IOException {
        JarOutputStream jos = null;
        try {
            jos = new JarOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(archiveFile)), new Manifest());
            int pathLength = tempJarDir.getAbsolutePath().length() + 1;
            Collection files = FileUtils.listFiles((File)tempJarDir, null, (boolean)true);
            for (File file : files) {
                if (!file.isFile()) continue;
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("file: " + file.getAbsolutePath()));
                }
                String name = file.getAbsolutePath().substring(pathLength);
                JarEntry jarFile = new JarEntry(name);
                jos.putNextEntry(jarFile);
                FileUtils.copyFile((File)file, (OutputStream)jos);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(jos);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)jos);
    }
}

