/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.openregistry.test.domain;

import java.util.Date;
import org.openregistry.core.domain.ActivationKey;
import org.openregistry.core.domain.LockingException;

public final class MockActivationKey
implements ActivationKey {
    private final String value;
    private final Date start;
    private final Date end;
    private String lock;

    public MockActivationKey(String value, Date start, Date end) {
        this.value = value;
        this.start = start;
        this.end = end;
    }

    public String asString() {
        return this.value;
    }

    public boolean isNotYetValid() {
        return this.start == null || this.start.compareTo(new Date()) > 0;
    }

    public boolean isExpired() {
        return this.end == null || this.end.compareTo(new Date()) < 0;
    }

    public boolean isValid() {
        return !this.isNotYetValid() && !this.isExpired();
    }

    public Date getStart() {
        return this.start;
    }

    public Date getEnd() {
        return this.end;
    }

    public int compareTo(ActivationKey activationKey) {
        return this.value.compareTo(activationKey.asString());
    }

    public void lock(String lock) throws LockingException {
        if (this.lock == null) {
            this.lock = lock;
            return;
        }
        if (!this.lock.equals(lock)) {
            throw new LockingException();
        }
    }

    public boolean hasLock(String lock) {
        return this.lock != null && this.lock.equals(lock);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MockActivationKey that = (MockActivationKey)o;
        if (this.end != null ? !this.end.equals(that.end) : that.end != null) {
            return false;
        }
        if (this.lock != null ? !this.lock.equals(that.lock) : that.lock != null) {
            return false;
        }
        if (this.start != null ? !this.start.equals(that.start) : that.start != null) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + (this.start != null ? this.start.hashCode() : 0);
        result = 31 * result + (this.end != null ? this.end.hashCode() : 0);
        result = 31 * result + (this.lock != null ? this.lock.hashCode() : 0);
        return result;
    }
}

