/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.openregistry.test.domain;

import org.openregistry.core.domain.AbstractNameImpl;
import org.openregistry.core.domain.Type;

public class MockName
extends AbstractNameImpl {
    private Long id;
    private Type type;
    private String prefix;
    private String given;
    private String middle;
    private String family;
    private String suffix;
    private boolean officialName = false;
    private boolean preferredName = false;

    public Long getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getGiven() {
        return this.given;
    }

    public String getMiddle() {
        return this.middle;
    }

    public String getFamily() {
        return this.family;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setGiven(String given) {
        this.given = given;
    }

    public void setMiddle(String middle) {
        this.middle = middle;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setOfficialName(boolean officialName) {
        this.officialName = officialName;
    }

    public boolean isOfficialName() {
        return this.officialName;
    }

    public void setPreferredName(boolean preferredName) {
        this.preferredName = preferredName;
    }

    public boolean isPreferredName() {
        return this.preferredName;
    }

    public String getFormattedName() {
        StringBuilder builder = new StringBuilder();
        this.construct(builder, "", this.family, ",");
        this.construct(builder, "", this.given, "");
        return builder.toString();
    }

    public String getLongFormattedName() {
        StringBuilder builder = new StringBuilder();
        if (this.prefix != null) {
            this.construct(builder, "", this.prefix, " ");
        }
        this.construct(builder, "", this.given, " ");
        if (this.middle != null) {
            this.construct(builder, "", this.middle, " ");
        }
        if (this.family != null) {
            this.construct(builder, "", this.family, " ");
        }
        if (this.suffix != null) {
            this.construct(builder, ",", this.suffix, "");
        }
        return builder.toString();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.construct(builder, "", this.prefix, " ");
        this.construct(builder, "", this.given, " ");
        this.construct(builder, "", this.middle, " ");
        this.construct(builder, "", this.family, "");
        this.construct(builder, ",", this.suffix, "");
        return builder.toString();
    }

    protected void construct(StringBuilder builder, String prefix, String string, String delimiter) {
        if (string != null) {
            builder.append(prefix);
            builder.append(string);
            builder.append(delimiter);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MockName mockName = (MockName)((Object)o);
        if (this.officialName != mockName.officialName) {
            return false;
        }
        if (this.preferredName != mockName.preferredName) {
            return false;
        }
        if (this.family != null ? !this.family.equals(mockName.family) : mockName.family != null) {
            return false;
        }
        if (this.given != null ? !this.given.equals(mockName.given) : mockName.given != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(mockName.id) : mockName.id != null) {
            return false;
        }
        if (this.middle != null ? !this.middle.equals(mockName.middle) : mockName.middle != null) {
            return false;
        }
        if (this.prefix != null ? !this.prefix.equals(mockName.prefix) : mockName.prefix != null) {
            return false;
        }
        if (this.suffix != null ? !this.suffix.equals(mockName.suffix) : mockName.suffix != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(mockName.type) : mockName.type != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
        result = 31 * result + (this.given != null ? this.given.hashCode() : 0);
        result = 31 * result + (this.middle != null ? this.middle.hashCode() : 0);
        result = 31 * result + (this.family != null ? this.family.hashCode() : 0);
        result = 31 * result + (this.suffix != null ? this.suffix.hashCode() : 0);
        result = 31 * result + (this.officialName ? 1 : 0);
        result = 31 * result + (this.preferredName ? 1 : 0);
        return result;
    }
}

