/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.deployer;

import java.io.IOException;
import java.io.InputStream;
import org.codehaus.plexus.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ClasspathEntityResolver
implements EntityResolver {
    protected final Logger logger;

    public ClasspathEntityResolver(Logger logger) {
        this.logger = logger;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String entityName = this.getEntityName(systemId);
        InputStream entityStream = this.getClass().getResourceAsStream(entityName);
        this.logger.debug("Resolved Entity for publicId: '" + publicId + "', systemId: '" + systemId + "'");
        if (entityStream != null) {
            return new InputSource(entityStream);
        }
        this.logger.warn("Failed to resolve entity for publicId: '" + publicId + "', systemId: '" + systemId + "'");
        return null;
    }

    protected String getEntityName(String systemId) {
        int lastSlashIndex = systemId.lastIndexOf(47);
        if (lastSlashIndex < 0) {
            return systemId;
        }
        String entityName = systemId.substring(lastSlashIndex);
        return entityName;
    }
}

