/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal.plugin.mojo;

import java.io.File;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.jasig.portal.plugin.deployer.DeployerConfig;
import org.jasig.portal.plugin.deployer.EarDeployer;
import org.jasig.portal.plugin.mojo.AbstractDeployEarMojo;

@Mojo(name="deploy-ear")
public class DeployEarMojo
extends AbstractDeployEarMojo {
    @Parameter(defaultValue="${project.artifact}", required=true, readonly=true)
    private Artifact artifact;
    @Parameter(defaultValue="${project.file}", required=true, readonly=true)
    private File pomFile;
    @Parameter(defaultValue="${project.packaging}", required=true, readonly=true)
    private String packaging;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!"ear".equals(this.packaging)) {
            throw new MojoExecutionException("deploy-ear only works on 'ear' packaged projects");
        }
        EarDeployer earDeployer = this.getEarDeployer();
        ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(this.artifact, this.pomFile);
        this.artifact.addMetadata((ArtifactMetadata)metadata);
        File earFile = this.artifact.getFile();
        if (earFile == null) {
            throw new MojoExecutionException("No build artifact is configured: " + this.artifact + "/" + this.artifact.getClass());
        }
        DeployerConfig deployerConfig = this.getDeployerConfig();
        deployerConfig.setEarLocation(earFile);
        earDeployer.deploy(deployerConfig);
    }
}

