/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.portlets.portletadmin.xmlsupport;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class CPDParameterTypeRestriction implements ICPDOptionTypeRestriction, Serializable {

	private String type;
	
	private String min;
	private String max;
	
	private List<CPDParameterTypeRestrictionValue> values = new ArrayList<CPDParameterTypeRestrictionValue>();

	private String defaultValue;
	
	public CPDParameterTypeRestriction() { }
	
	public CPDParameterTypeRestriction(String type, String min, String max, List<CPDParameterTypeRestrictionValue> values, String defaultValue) {
		this.type = type;
		this.min = min;
		this.max = max;
		this.values = values;
		this.defaultValue = defaultValue;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getMin() {
		return min;
	}

	public void setMin(String min) {
		this.min = min;
	}

	public String getMax() {
		return max;
	}

	public void setMax(String max) {
		this.max = max;
	}

	public List<CPDParameterTypeRestrictionValue> getValues() {
		return values;
	}

	public void setValues(List<CPDParameterTypeRestrictionValue> values) {
		this.values = values;
	}
	
	public void addValue(CPDParameterTypeRestrictionValue value) {
		this.values.add(value);
	}

	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

}
