/**
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a
 * copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.jasig.portal.security;

import org.jasig.portal.IBasicEntity;

/**
 * @author Dan Ellentuck, de3@columbia.edu
 * @version $Revision: 19776 $
 *
 * A type that aggregates the <code>IPermissions</code> for an 
 * <code>IAuthorizationPrincipal</code> so that permissions can be
 * cached by the <code>EntityCachingService</code>.
 */
public interface IPermissionSet extends IBasicEntity {
    public IPermission[] getPermissions();
}
