/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.aopalliance.aop.Advice;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.ChannelCacheEntry;
import org.jasig.portal.ChannelCacheKey;
import org.jasig.portal.ChannelRuntimeData;
import org.jasig.portal.ChannelRuntimeProperties;
import org.jasig.portal.ICacheable;
import org.jasig.portal.IChannel;
import org.jasig.portal.IChannelRenderer;
import org.jasig.portal.ICharacterChannel;
import org.jasig.portal.InternalPortalException;
import org.jasig.portal.PortalException;
import org.jasig.portal.channels.portlet.IPortletAdaptor;
import org.jasig.portal.channels.support.IChannelTitle;
import org.jasig.portal.channels.support.IDynamicChannelTitleRenderer;
import org.jasig.portal.portlet.url.RequestType;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.spring.locator.CacheFactoryLocator;
import org.jasig.portal.spring.locator.JpaInterceptorLocator;
import org.jasig.portal.utils.SAX2BufferImpl;
import org.jasig.portal.utils.SetCheckInSemaphore;
import org.jasig.portal.utils.cache.CacheFactory;
import org.jasig.portal.utils.threading.BaseTask;
import org.jasig.portal.utils.threading.Task;
import org.jasig.portal.utils.threading.TrackingThreadLocal;
import org.springframework.aop.framework.ProxyFactoryBean;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.orm.jpa.JpaInterceptor;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

@Deprecated
public class ChannelRenderer
implements IChannelRenderer,
IDynamicChannelTitleRenderer {
    protected final Log log = LogFactory.getLog(this.getClass());
    private static final boolean DEFAULT_CACHE_CHANNELS = false;
    public static final boolean CACHE_CHANNELS = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.ChannelRenderer.cache_channels", false);
    public static final String[] renderingStatus = new String[]{"successful", "failed", "timed out"};
    public static final String SYSTEM_WIDE_CHANNEL_CACHE = "org.jasig.portal.ChannelRenderer.SYSTEM_WIDE_CHANNEL_CACHE";
    protected final IChannel channel;
    protected final ChannelRuntimeData rd;
    protected Map<String, ChannelCacheEntry> channelCache;
    protected Map<IChannel, Map<String, ChannelCacheEntry>> cacheTables;
    protected boolean rendering;
    protected boolean donerendering;
    protected Thread workerThread;
    protected IWorker worker;
    protected Future<?> workTracker;
    protected long startTime;
    protected long timeOut = Long.MAX_VALUE;
    protected boolean ccacheable;
    protected static ExecutorService tp = null;
    protected SetCheckInSemaphore groupSemaphore;
    protected Object groupRenderingKey;

    public ChannelRenderer(IChannel chan, ChannelRuntimeData runtimeData, ExecutorService threadPool) {
        Validate.notNull((Object)chan, (String)"IChannel can not be null");
        this.channel = chan;
        this.rd = runtimeData;
        this.rendering = false;
        this.ccacheable = false;
        tp = threadPool;
        this.groupSemaphore = null;
        this.groupRenderingKey = null;
    }

    public ChannelRenderer(IChannel chan, ChannelRuntimeData runtimeData, ExecutorService threadPool, SetCheckInSemaphore groupSemaphore, Object groupRenderingKey) {
        this(chan, runtimeData, threadPool);
        this.groupSemaphore = groupSemaphore;
        this.groupRenderingKey = groupRenderingKey;
    }

    Map<String, ChannelCacheEntry> getChannelCache() {
        if (this.channelCache == null && (this.channelCache = this.cacheTables.get(this.channel)) == null) {
            this.channelCache = new ReferenceMap(0, 1, 2, 0.75f, true);
            this.cacheTables.put(this.channel, this.channelCache);
        }
        return this.channelCache;
    }

    @Override
    public void setTimeout(long value) {
        this.timeOut = value;
    }

    @Override
    public void setCacheTables(Map<IChannel, Map<String, ChannelCacheEntry>> cacheTables) {
        this.cacheTables = cacheTables;
    }

    @Override
    public void setCharacterCacheable(boolean setting) {
        this.ccacheable = setting;
    }

    @Override
    public void startRendering() {
        Worker targetWorker = new Worker(this.channel, this.rd);
        JpaInterceptor jpaInterceptor = JpaInterceptorLocator.getJpaInterceptor();
        ProxyFactoryBean pfb = new ProxyFactoryBean();
        pfb.setTarget((Object)targetWorker);
        pfb.setInterfaces((Class[])targetWorker.getClass().getInterfaces());
        pfb.addAdvice((Advice)jpaInterceptor);
        this.worker = (IWorker)pfb.getObject();
        this.workTracker = tp.submit(this.worker);
        this.rendering = true;
        this.startTime = System.currentTimeMillis();
    }

    @Override
    public void startRendering(SetCheckInSemaphore groupSemaphore, Object groupRenderingKey) {
        this.groupSemaphore = groupSemaphore;
        this.groupRenderingKey = groupRenderingKey;
        this.startRendering();
    }

    @Override
    public void cancelRendering() {
        if (null != this.workTracker) {
            this.workTracker.cancel(true);
        }
    }

    @Override
    public int outputRendering(ContentHandler out) throws Throwable {
        int renderingStatus = this.completeRendering();
        if (renderingStatus == 0) {
            SAX2BufferImpl buffer = this.worker.getBuffer();
            if (buffer != null) {
                try {
                    buffer.setAllHandlers(out);
                    buffer.outputBuffer();
                    return 0;
                }
                catch (SAXException e) {
                    this.log.error((Object)("outputRendering() : following SAX exception occured : " + e));
                    throw e;
                }
            }
            this.log.error((Object)"outputRendering() : output buffer is null even though rendering was a success?! trying to rendering for ccaching ?");
            throw new PortalException("unable to obtain rendering buffer");
        }
        return renderingStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int completeRendering() throws Throwable {
        if (!this.rendering) {
            this.startRendering();
        }
        boolean abandoned = false;
        long timeOutTarget = this.startTime + this.timeOut;
        if (this.groupSemaphore != null) {
            while (!this.worker.isSetRuntimeDataComplete() && System.currentTimeMillis() < timeOutTarget && !this.workTracker.isDone()) {
                long wait = timeOutTarget - System.currentTimeMillis();
                if (wait <= 0L) {
                    wait = 1L;
                }
                try {
                    SetCheckInSemaphore setCheckInSemaphore = this.groupSemaphore;
                    synchronized (setCheckInSemaphore) {
                        this.groupSemaphore.wait(wait);
                    }
                }
                catch (InterruptedException ie) {
                }
            }
            if (!this.worker.isSetRuntimeDataComplete() && !this.workTracker.isDone()) {
                this.workTracker.cancel(true);
                abandoned = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("outputRendering() : killed. (key=" + this.groupRenderingKey.toString() + ")"));
                }
            } else {
                this.groupSemaphore.waitOn();
            }
            timeOutTarget = System.currentTimeMillis() + this.timeOut;
        }
        if (!abandoned) {
            block28: {
                try {
                    this.workTracker.get(this.timeOut, TimeUnit.MILLISECONDS);
                }
                catch (TimeoutException te) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("outputRendering() : channel [" + this.channel + "] timed out"), (Throwable)te);
                    }
                }
                catch (CancellationException ce) {
                    if (!this.log.isDebugEnabled()) break block28;
                    Exception t = null;
                    try {
                        t = this.worker.getException();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    this.log.debug((Object)("outputRendering() : channel [" + this.channel + "] threw an exception [" + t + "] and so its task was cancelled."));
                }
                catch (Exception e) {
                    this.log.error((Object)("Unexpected exceptional condition trying to get the result from the workTracker Future rendering channel [" + this.channel + "]."), (Throwable)e);
                }
            }
            if (!this.workTracker.isDone()) {
                this.workTracker.cancel(true);
                abandoned = true;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"outputRendering() : killed.");
                }
            } else {
                boolean successful = this.workTracker.isDone() && !this.workTracker.isCancelled() && this.worker.getException() == null;
                boolean bl = abandoned = !successful;
            }
        }
        if (!abandoned && this.worker.done()) {
            if (this.worker.successful() && (this.rd != null && RequestType.ACTION.equals((Object)this.rd.getRequestType()) || this.worker.getBuffer() != null || this.worker.getCharacters() != null)) {
                return 0;
            }
            Exception e = this.worker.getException();
            if (e != null) {
                throw new InternalPortalException(e);
            }
            return 1;
        }
        Exception e = null;
        if (this.worker != null) {
            e = this.worker.getException();
        }
        if (e != null) {
            throw new InternalPortalException(e);
        }
        return 2;
    }

    @Override
    public SAX2BufferImpl getBuffer() {
        return this.worker != null ? this.worker.getBuffer() : null;
    }

    @Override
    public String getCharacters() {
        if (this.worker != null) {
            return this.worker.getCharacters();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"getCharacters() : worker is null already !");
        }
        return null;
    }

    @Override
    public long getRenderTime() {
        return this.worker.getRenderTime();
    }

    @Override
    public boolean isRenderedFromCache() {
        return this.worker.isRenderedFromCache();
    }

    @Override
    public void setCharacterCache(String chars) {
        if (this.worker != null) {
            this.worker.setCharacterCache(chars);
        }
    }

    @Override
    public void kill() {
        if (this.workTracker != null && !this.workTracker.isDone()) {
            this.workTracker.cancel(true);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + "channel=" + this.channel + ", " + "rendering=" + this.rendering + ", " + "doneRendering=" + this.donerendering + ", " + "startTime=" + this.startTime + ", " + "timeOut=" + this.timeOut + "]";
    }

    @Override
    public String getChannelTitle() {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Getting channel title for ChannelRenderer " + this));
        }
        String channelTitle = null;
        try {
            int renderingStatus = this.completeRendering();
            if (renderingStatus == 0) {
                channelTitle = this.worker.getChannelTitle();
            }
        }
        catch (Throwable t) {
            this.log.error((Object)("Channel rendering failed while getting title for channel renderer " + this), t);
        }
        return channelTitle;
    }

    protected static interface IWorker
    extends Task {
        public boolean isSetRuntimeDataComplete();

        public void execute() throws Exception;

        public boolean successful();

        public SAX2BufferImpl getBuffer();

        public String getCharacters();

        public void setCharacterCache(String var1);

        public boolean done();

        public long getRenderTime();

        public boolean isRenderedFromCache();

        public String getChannelTitle();
    }

    protected class Worker
    extends BaseTask
    implements IWorker {
        private final IChannel channel;
        private final ChannelRuntimeData rd;
        private final Map<TrackingThreadLocal<Object>, Object> currentData;
        private final RequestAttributes requestAttributes;
        private final Locale locale;
        private boolean successful;
        private boolean done;
        private boolean setRuntimeDataComplete;
        private SAX2BufferImpl buffer;
        private String cbuffer;
        private long renderTime;
        private boolean renderedFromCache = false;
        private String channelTitle = null;

        public Worker(IChannel ch, ChannelRuntimeData runtimeData) {
            this.channel = ch;
            this.rd = runtimeData;
            this.requestAttributes = RequestContextHolder.getRequestAttributes();
            this.locale = LocaleContextHolder.getLocale();
            this.successful = false;
            this.done = false;
            this.setRuntimeDataComplete = false;
            this.buffer = null;
            this.cbuffer = null;
            this.currentData = TrackingThreadLocal.getCurrentData();
            if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("Created " + this.toString()));
            }
        }

        @Override
        public boolean isSetRuntimeDataComplete() {
            return this.setRuntimeDataComplete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute() throws Exception {
            if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("Started execution " + this.toString()));
            }
            long startTime = System.currentTimeMillis();
            try {
                TrackingThreadLocal.setCurrentData(this.currentData);
                RequestContextHolder.setRequestAttributes((RequestAttributes)this.requestAttributes);
                LocaleContextHolder.setLocale((Locale)this.locale);
                if (ChannelRenderer.this.log.isDebugEnabled()) {
                    ChannelRenderer.this.log.debug((Object)("Bound request attributes to thread: " + this.requestAttributes));
                }
                if (this.rd != null) {
                    this.channel.setRuntimeData(this.rd);
                    if (RequestType.ACTION.equals((Object)this.rd.getRequestType())) {
                        if (this.channel instanceof IPortletAdaptor) {
                            try {
                                ((IPortletAdaptor)this.channel).processAction();
                                this.successful = true;
                            }
                            catch (Exception e) {
                                this.setException(e);
                            }
                        } else {
                            this.setException(new ClassCastException("Action request for channel '" + this.channel + "' that does not implement '" + IPortletAdaptor.class + "'"));
                        }
                        this.done = true;
                        return;
                    }
                }
                this.setRuntimeDataComplete = true;
                if (ChannelRenderer.this.groupSemaphore != null) {
                    ChannelRenderer.this.groupSemaphore.checkInAndWaitOn(ChannelRenderer.this.groupRenderingKey);
                }
                if (CACHE_CHANNELS) {
                    if (this.channel instanceof ICacheable) {
                        CacheFactory cacheFactory = CacheFactoryLocator.getCacheFactory();
                        Map<String, ChannelCacheEntry> systemCache = cacheFactory.getCache(ChannelRenderer.SYSTEM_WIDE_CHANNEL_CACHE);
                        ChannelCacheKey key = ((ICacheable)((Object)this.channel)).generateKey();
                        if (ChannelRenderer.this.log.isTraceEnabled()) {
                            ChannelRenderer.this.log.trace((Object)("Generated cache key " + (key != null ? key.getKey() : null) + " for worker " + this.toString()));
                        }
                        if (key != null) {
                            ChannelCacheEntry entry;
                            if (key.getKeyScope() == 1) {
                                entry = (ChannelCacheEntry)systemCache.get(key.getKey());
                                if (entry != null) {
                                    if (((ICacheable)((Object)this.channel)).isCacheValid(entry.validity) && entry.buffer != null) {
                                        if (ChannelRenderer.this.ccacheable && entry.buffer instanceof String) {
                                            this.cbuffer = (String)entry.buffer;
                                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                                ChannelRenderer.this.log.debug((Object)("retrieved system-wide cached character content based on a key \"" + key.getKey() + "\""));
                                            }
                                        } else if (entry.buffer instanceof SAX2BufferImpl) {
                                            this.buffer = (SAX2BufferImpl)entry.buffer;
                                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                                ChannelRenderer.this.log.debug((Object)("retrieved system-wide cached content based on a key \"" + key.getKey() + "\""));
                                            }
                                        }
                                        this.channelTitle = entry.title;
                                        this.renderedFromCache = true;
                                    } else {
                                        systemCache.remove(key.getKey());
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("removed system-wide unvalidated cache based on a key \"" + key.getKey() + "\""));
                                        }
                                    }
                                }
                            } else {
                                entry = ChannelRenderer.this.getChannelCache().get(key.getKey());
                                if (entry != null) {
                                    if (((ICacheable)((Object)this.channel)).isCacheValid(entry.validity) && entry.buffer != null) {
                                        if (ChannelRenderer.this.ccacheable && entry.buffer instanceof String) {
                                            this.cbuffer = (String)entry.buffer;
                                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                                ChannelRenderer.this.log.debug((Object)("retrieved instance-cached character content based on a key \"" + key.getKey() + "\" by " + this.toString()));
                                            }
                                        } else if (entry.buffer instanceof SAX2BufferImpl) {
                                            this.buffer = (SAX2BufferImpl)entry.buffer;
                                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                                ChannelRenderer.this.log.debug((Object)("retrieved instance-cached content based on a key \"" + key.getKey() + "\" by " + this.toString()));
                                            }
                                        }
                                        this.channelTitle = entry.title;
                                        this.renderedFromCache = true;
                                    } else {
                                        ChannelRenderer.this.getChannelCache().remove(key.getKey());
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("removed unvalidated instance-cache based on a key \"" + key.getKey() + "\" by " + this.toString()));
                                        }
                                    }
                                }
                            }
                        }
                        if (this.cbuffer == null && this.buffer == null) {
                            if (this.channel instanceof ICharacterChannel) {
                                StringWriter sw = new StringWriter(100);
                                PrintWriter pw = new PrintWriter(sw);
                                ((ICharacterChannel)this.channel).renderCharacters(pw);
                                this.processChannelRuntimeProperties();
                                pw.flush();
                                this.cbuffer = sw.toString();
                                if (ChannelRenderer.this.ccacheable && key != null) {
                                    if (key.getKeyScope() == 1) {
                                        systemCache.put(key.getKey(), new ChannelCacheEntry(this.cbuffer, this.channelTitle, key.getKeyValidity()));
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("recorded system character cache based on a key \"" + key.getKey() + "\" by " + this.toString()));
                                        }
                                    } else {
                                        ChannelRenderer.this.getChannelCache().put(key.getKey(), new ChannelCacheEntry(this.cbuffer, this.channelTitle, key.getKeyValidity()));
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("recorded instance character cache based on a key \"" + key.getKey() + "\" by " + this.toString()));
                                        }
                                    }
                                }
                            } else {
                                this.buffer = new SAX2BufferImpl();
                                this.buffer.startBuffering();
                                this.channel.renderXML(this.buffer);
                                this.processChannelRuntimeProperties();
                                if (key != null) {
                                    if (key.getKeyScope() == 1) {
                                        systemCache.put(key.getKey(), new ChannelCacheEntry(this.buffer, this.channelTitle, key.getKeyValidity()));
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("recorded system cache based on a key \"" + key.getKey() + "\""));
                                        }
                                    } else {
                                        ChannelRenderer.this.getChannelCache().put(key.getKey(), new ChannelCacheEntry(this.buffer, this.channelTitle, key.getKeyValidity()));
                                        if (ChannelRenderer.this.log.isDebugEnabled()) {
                                            ChannelRenderer.this.log.debug((Object)("recorded instance cache based on a key \"" + key.getKey() + "\""));
                                        }
                                    }
                                }
                            }
                        }
                    } else if (ChannelRenderer.this.ccacheable && this.channel instanceof ICharacterChannel) {
                        StringWriter sw = new StringWriter(100);
                        PrintWriter pw = new PrintWriter(sw);
                        ((ICharacterChannel)this.channel).renderCharacters(pw);
                        pw.flush();
                        this.cbuffer = sw.toString();
                    } else {
                        this.buffer = new SAX2BufferImpl();
                        this.buffer.startBuffering();
                        this.channel.renderXML(this.buffer);
                    }
                } else {
                    this.buffer = new SAX2BufferImpl();
                    this.buffer.startBuffering();
                    this.channel.renderXML(this.buffer);
                }
                this.successful = true;
            }
            catch (Exception e) {
                if (ChannelRenderer.this.groupSemaphore != null) {
                    ChannelRenderer.this.groupSemaphore.checkIn(ChannelRenderer.this.groupRenderingKey);
                }
                this.setException(e);
            }
            finally {
                TrackingThreadLocal.clearCurrentData(this.currentData.keySet());
                RequestContextHolder.resetRequestAttributes();
                LocaleContextHolder.resetLocaleContext();
                this.renderTime = System.currentTimeMillis() - startTime;
            }
            this.done = true;
            if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("Completed execution " + this.toString()));
            }
        }

        private void processChannelRuntimeProperties() {
            ChannelRuntimeProperties channelProps = this.channel.getRuntimeProperties();
            if (channelProps != null) {
                if (channelProps instanceof IChannelTitle) {
                    this.channelTitle = ((IChannelTitle)((Object)channelProps)).getChannelTitle();
                    if (ChannelRenderer.this.log.isTraceEnabled()) {
                        ChannelRenderer.this.log.trace((Object)("Read title [" + this.channelTitle + "] by " + this.toString()));
                    }
                } else if (ChannelRenderer.this.log.isTraceEnabled()) {
                    ChannelRenderer.this.log.trace((Object)"ChannelRuntimeProperties were non-null but did not implement ITitleable.");
                }
            } else if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("ChannelRuntimeProperties were null from channel " + this.channel));
            }
        }

        @Override
        public boolean successful() {
            return this.successful;
        }

        @Override
        public SAX2BufferImpl getBuffer() {
            return this.buffer;
        }

        @Override
        public String getCharacters() {
            if (!ChannelRenderer.this.ccacheable) {
                ChannelRenderer.this.log.error((Object)("Attempting to obtain character data for '" + this.channel + "' while character caching is not enabled !"), new Throwable());
                return null;
            }
            if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("Getting channel characters (" + (this.cbuffer != null ? this.cbuffer.length() : 0) + ") for " + this));
            }
            return this.cbuffer;
        }

        @Override
        public void setCharacterCache(String chars) {
            this.cbuffer = chars;
            if (CACHE_CHANNELS && this.channel instanceof ICacheable) {
                CacheFactory cacheFactory = CacheFactoryLocator.getCacheFactory();
                Map<String, ChannelCacheEntry> systemCache = cacheFactory.getCache(ChannelRenderer.SYSTEM_WIDE_CHANNEL_CACHE);
                ChannelCacheKey key = ((ICacheable)((Object)this.channel)).generateKey();
                if (key != null) {
                    if (ChannelRenderer.this.log.isDebugEnabled()) {
                        ChannelRenderer.this.log.debug((Object)("setCharacterCache() : called on a key \"" + key.getKey() + "\""));
                    }
                    ChannelCacheEntry entry = null;
                    if (key.getKeyScope() == 1) {
                        entry = (ChannelCacheEntry)systemCache.get(key.getKey());
                        if (entry == null) {
                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                ChannelRenderer.this.log.debug((Object)("setCharacterCache() : setting character cache buffer based on a system key \"" + key.getKey() + "\""));
                            }
                            entry = new ChannelCacheEntry(chars, this.channelTitle, key.getKeyValidity());
                        } else {
                            entry.buffer = chars;
                            entry.title = this.channelTitle;
                        }
                        systemCache.put(key.getKey(), entry);
                    } else {
                        entry = ChannelRenderer.this.getChannelCache().get(key.getKey());
                        if (entry == null) {
                            if (ChannelRenderer.this.log.isDebugEnabled()) {
                                ChannelRenderer.this.log.debug((Object)("setCharacterCache() : no existing cache on a key \"" + key.getKey() + "\""));
                            }
                            entry = new ChannelCacheEntry(chars, this.channelTitle, key.getKeyValidity());
                        } else {
                            entry.buffer = chars;
                            entry.title = this.channelTitle;
                        }
                        ChannelRenderer.this.getChannelCache().put(key.getKey(), entry);
                    }
                } else if (ChannelRenderer.this.log.isDebugEnabled()) {
                    ChannelRenderer.this.log.debug((Object)"setCharacterCache() : channel cache key is null.");
                }
            }
        }

        @Override
        public boolean done() {
            return this.done;
        }

        @Override
        public String getChannelTitle() {
            if (ChannelRenderer.this.log.isTraceEnabled()) {
                ChannelRenderer.this.log.trace((Object)("Getting channel title (" + this.channelTitle + ") for " + this));
            }
            if (this.done) {
                return this.channelTitle;
            }
            return null;
        }

        @Override
        public long getRenderTime() {
            return this.renderTime;
        }

        @Override
        public boolean isRenderedFromCache() {
            return this.renderedFromCache;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [" + "channel=" + this.channel + ", " + "done=" + this.done + ", " + "successful=" + this.successful + ", " + "renderTime=" + this.renderTime + ", " + "renderedFromCache=" + this.renderedFromCache + ", " + "cbuffer.length=" + (this.cbuffer != null ? this.cbuffer.length() : 0) + ", " + "parent=" + ChannelRenderer.this + "]";
        }
    }
}

