/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.PortalException;
import org.jasig.portal.StructureStylesheetDescription;
import org.jasig.portal.ThemeStylesheetDescription;
import org.jasig.portal.UserPreferences;
import org.jasig.portal.UserPreferencesManager;
import org.jasig.portal.UserProfile;
import org.jasig.portal.i18n.LocaleManager;
import org.jasig.portal.jndi.IJndiManager;
import org.jasig.portal.layout.IUserLayoutManager;
import org.jasig.portal.layout.UserLayoutManagerFactory;
import org.jasig.portal.layout.UserLayoutStoreFactory;
import org.jasig.portal.layout.node.IUserLayoutChannelDescription;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.spring.locator.JndiManagerLocator;
import org.jasig.portal.utils.PropsMatcher;
import org.w3c.dom.Document;

public class GuestUserPreferencesManager
extends UserPreferencesManager {
    private static final Log log = LogFactory.getLog(GuestUserPreferencesManager.class);
    Map<String, MState> stateTable = Collections.synchronizedMap(new HashMap());
    Hashtable<Integer, IUserLayoutManager> sp_layouts;
    Hashtable<Integer, IUserLayoutManager> up_layouts;
    Hashtable<Integer, UserPreferences> sp_cleanUPs;
    Hashtable<Integer, UserPreferences> up_cleanUPs = new Hashtable();
    Hashtable<Integer, ThemeStylesheetDescription> ts_descripts;
    Hashtable<Integer, StructureStylesheetDescription> ss_descripts;
    Hashtable<String, UserProfile> cached_profiles;
    IPerson m_person;
    LocaleManager localeManager;
    static final boolean SAVE_PROFILE_GUESSES = PropertiesManager.getPropertyAsBoolean("org.jasig.portal.GuestUserPreferencesManager.save_profile_guesses");

    public GuestUserPreferencesManager(IPerson person) {
        super(person);
        this.sp_cleanUPs = new Hashtable();
        this.sp_layouts = new Hashtable();
        this.up_layouts = new Hashtable();
        this.cached_profiles = new Hashtable();
        this.ts_descripts = new Hashtable();
        this.ss_descripts = new Hashtable();
        this.m_person = person;
        this.userLayoutStore = UserLayoutStoreFactory.getUserLayoutStoreImpl();
    }

    public void unbindSession(String sessionId) {
        this.stateTable.remove(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(HttpServletRequest req) throws PortalException {
        MState newState;
        block34: {
            newState = new MState();
            try {
                PropsMatcher userAgentMatcher;
                UserProfile upl;
                String userAgent = req.getHeader("User-Agent");
                if (userAgent == null || userAgent.equals("")) {
                    userAgent = "null";
                }
                if ((upl = this.cached_profiles.get(userAgent)) == null) {
                    Hashtable<String, UserProfile> hashtable = this.cached_profiles;
                    synchronized (hashtable) {
                        upl = this.userLayoutStore.getUserProfile(this.m_person, userAgent);
                        if (upl == null) {
                            upl = this.userLayoutStore.getSystemProfile(userAgent);
                        }
                        if (upl != null) {
                            this.cached_profiles.put(userAgent, upl);
                        }
                    }
                }
                if (upl == null && (userAgentMatcher = GuestUserPreferencesManager.getUserAgentMatcher()) != null) {
                    String profileFname = userAgentMatcher.match(userAgent);
                    if (profileFname != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("GuestUserPreferencesManager::GuestUserPreferencesManager() : userAgent \"" + userAgent + "\" has matched to a profile " + profileFname));
                        }
                        if ((upl = this.userLayoutStore.getUserProfileByFname(this.m_person, profileFname)) == null) {
                            upl = this.userLayoutStore.getSystemProfileByFname(profileFname);
                        }
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)("GuestUserPreferencesManager::GuestUserPreferencesManager() : userAgent \"" + userAgent + "\" has not matched any profile."));
                    }
                }
                if (upl != null) {
                    UserPreferences cleanUP;
                    if (upl.isSystemProfile()) {
                        newState.ulm = this.sp_layouts.get(new Integer(upl.getProfileId()));
                    } else {
                        newState.ulm = this.up_layouts.get(new Integer(upl.getProfileId()));
                    }
                    if (newState.ulm == null) {
                        try {
                            upl.setLocaleManager(this.localeManager);
                            newState.ulm = UserLayoutManagerFactory.immutableUserLayoutManager(UserLayoutManagerFactory.getUserLayoutManager(this.m_person, upl));
                            if (upl.isSystemProfile()) {
                                this.sp_layouts.put(new Integer(upl.getProfileId()), newState.ulm);
                            } else {
                                this.up_layouts.put(new Integer(upl.getProfileId()), newState.ulm);
                            }
                        }
                        catch (PortalException pe) {
                            throw pe;
                        }
                        catch (Exception e) {
                            throw new PortalException("GuestUserPreferencesManager::registerSession() : caught an exception while trying to retreive a userLayout for user=\"" + this.m_person.getID() + "\", profile=\"" + upl.getProfileName() + "\".", (Throwable)e);
                        }
                    }
                    if ((cleanUP = upl.isSystemProfile() ? this.sp_cleanUPs.get(new Integer(upl.getProfileId())) : this.up_cleanUPs.get(new Integer(upl.getProfileId()))) == null) {
                        try {
                            cleanUP = this.userLayoutStore.getUserPreferences(this.m_person, upl);
                            if (cleanUP != null) {
                                if (upl.isSystemProfile()) {
                                    this.sp_cleanUPs.put(new Integer(upl.getProfileId()), cleanUP);
                                } else {
                                    this.up_cleanUPs.put(new Integer(upl.getProfileId()), cleanUP);
                                }
                            }
                        }
                        catch (Exception e) {
                            log.error((Object)("GuestUserPreferencesManager::registerSession() : unable to find UP for a profile \"" + upl.getProfileName() + "\""), (Throwable)e);
                            cleanUP = new UserPreferences(upl);
                        }
                    }
                    if (cleanUP != null) {
                        newState.complete_up = new UserPreferences(cleanUP);
                    } else {
                        log.error((Object)("GuestUserPreferencesManager::registerSession() : unable to find UP for a profile \"" + upl.getProfileName() + "\""));
                        newState.complete_up = new UserPreferences(upl);
                    }
                    IJndiManager jndiManager = JndiManagerLocator.getJndiManager();
                    HttpSession session = req.getSession();
                    String userId = Integer.toString(this.m_person.getID());
                    String layoutId = Integer.toString(upl.getLayoutId());
                    Document userLayoutDom = newState.ulm.getUserLayoutDOM();
                    jndiManager.initializeSessionContext(session, userId, layoutId, userLayoutDom);
                    break block34;
                }
                newState.unmapped_user_agent = true;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("GuestUserPreferencesManager::registerSession() : unable to find a profile for user \"" + this.m_person.getID() + "\" and userAgent=\"" + userAgent + "\"."));
                }
            }
            catch (PortalException pe) {
                throw pe;
            }
            catch (Throwable t) {
                throw new PortalException(t);
            }
        }
        this.stateTable.put(req.getSession(false).getId(), newState);
    }

    protected String getChannelGlobalId(String channelSubscribeId, String sessionId) throws PortalException {
        IUserLayoutChannelDescription channel = (IUserLayoutChannelDescription)this.getUserLayoutManager(sessionId).getNode(channelSubscribeId);
        if (channel != null) {
            return channel.getChannelPublishId();
        }
        return null;
    }

    public boolean isUserAgentUnmapped(String sessionId) {
        MState state = this.stateTable.get(sessionId);
        if (state == null) {
            throw new IllegalStateException("Trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
        }
        return state.unmapped_user_agent;
    }

    @Override
    public boolean isUserAgentUnmapped() {
        throw new UnsupportedOperationException();
    }

    public UserPreferences getUserPreferences(String sessionId) {
        MState state = this.stateTable.get(sessionId);
        if (state == null) {
            throw new IllegalStateException("Trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
        }
        return state.complete_up;
    }

    @Override
    public UserPreferences getUserPreferences() {
        throw new UnsupportedOperationException();
    }

    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newLayout, UserPreferences newPreferences, String sessionId) throws PortalException {
    }

    @Override
    public void setNewUserLayoutAndUserPreferences(IUserLayoutManager newLayout, UserPreferences newPreferences) throws PortalException {
        throw new UnsupportedOperationException();
    }

    public UserPreferences getUserPreferencesCopy(String sessionId) {
        return new UserPreferences(this.getUserPreferences(sessionId));
    }

    @Override
    public UserPreferences getUserPreferencesCopy() {
        throw new UnsupportedOperationException();
    }

    public UserProfile getCurrentProfile(String sessionId) {
        return this.getUserPreferences(sessionId).getProfile();
    }

    @Override
    public UserProfile getCurrentProfile() {
        throw new UnsupportedOperationException();
    }

    public ThemeStylesheetDescription getThemeStylesheetDescription(String sessionId) throws Exception {
        MState state = this.stateTable.get(sessionId);
        if (state == null) {
            throw new IllegalStateException("Trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
        }
        if (state.tsd == null) {
            int sid = state.complete_up.getProfile().getThemeStylesheetId();
            state.tsd = this.ts_descripts.get(new Integer(sid));
            if (state.tsd == null) {
                state.tsd = this.userLayoutStore.getThemeStylesheetDescription(sid);
                this.ts_descripts.put(new Integer(sid), state.tsd);
            }
        }
        return state.tsd;
    }

    @Override
    public ThemeStylesheetDescription getThemeStylesheetDescription() {
        throw new UnsupportedOperationException();
    }

    public StructureStylesheetDescription getStructureStylesheetDescription(String sessionId) throws Exception {
        MState state = this.stateTable.get(sessionId);
        if (state == null) {
            throw new IllegalStateException("Trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
        }
        if (state.ssd == null) {
            int sid = state.complete_up.getProfile().getStructureStylesheetId();
            state.ssd = this.ss_descripts.get(new Integer(sid));
            if (state.ssd == null) {
                state.ssd = this.userLayoutStore.getStructureStylesheetDescription(sid);
                this.ss_descripts.put(new Integer(sid), state.ssd);
            }
        }
        return state.ssd;
    }

    @Override
    public StructureStylesheetDescription getStructureStylesheetDescription() {
        throw new UnsupportedOperationException();
    }

    public IUserLayoutManager getUserLayoutManager(String sessionId) {
        MState state = this.stateTable.get(sessionId);
        if (state == null) {
            throw new IllegalStateException("Trying to envoke a method on a non-registered sessionId=\"" + sessionId + "\".");
        }
        return state.ulm;
    }

    @Override
    public IUserLayoutManager getUserLayoutManager() {
        throw new UnsupportedOperationException();
    }

    public void finishedSession(HttpSession session, String sessionId) {
        this.stateTable.remove(sessionId);
    }

    @Override
    public void finishedSession(HttpSession session) {
        String sessionId = session.getId();
        this.finishedSession(session, sessionId);
    }

    public void setLocaleManager(LocaleManager lm) {
        this.localeManager = lm;
    }

    private class MState {
        private ThemeStylesheetDescription tsd = null;
        private StructureStylesheetDescription ssd = null;
        private boolean unmapped_user_agent = false;
        private UserPreferences complete_up = null;
        private IUserLayoutManager ulm;
    }
}

