/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jasig.portal.CountID;
import org.jasig.portal.ErrorID;
import org.jasig.portal.PortalException;
import org.jasig.portal.properties.PropertiesManager;

public class ProblemsTable {
    public static Map<String, Map<String, CountID>> registeredIds = new TreeMap<String, Map<String, CountID>>();
    public static LinkedList<CountID> recentIds = new LinkedList();
    private static LinkedList<PortalException> recentPortalExceptions = new LinkedList();
    public static final String MAX_RECENT_ERRORS_PER_SPECIFIC_PROPERTY = "org.jasig.portal.ProblemsTable.maxRecentErrorsPerSpecific";
    private static final int DEFAULT_MAX_RECENT_PER_SPECIFIC = 10;
    private static final int maxRecent = PropertiesManager.getPropertyAsInt("org.jasig.portal.ProblemsTable.maxRecentErrorsPerSpecific", 10);
    public static final String OVERALL_RECENT_ERRORS_PROPERTY = "org.jasig.portal.ProblemsTable.recentErrorsOverall";
    private static final int DEFAULT_OVERALL_RECENT_ERRORS_COUNT = 40;
    private static final int overallErrorsCount = PropertiesManager.getPropertyAsInt("org.jasig.portal.ProblemsTable.recentErrorsOverall", 40);

    public static synchronized void register(ErrorID id) {
        if (id == null) {
            return;
        }
        String category = id.getCategory();
        String specific = id.getSpecific();
        Map<String, CountID> minor = registeredIds.get(category);
        if (minor == null) {
            minor = new TreeMap<String, CountID>();
            registeredIds.put(category, minor);
        }
        if (!minor.containsKey(specific)) {
            minor.put(specific, new CountID(id));
        }
    }

    public static synchronized void store(PortalException pe) {
        if (pe == null) {
            return;
        }
        if (recentPortalExceptions.contains(pe)) {
            return;
        }
        ErrorID id = pe.getErrorID();
        if (id == null) {
            return;
        }
        String category = id.getCategory();
        String specific = id.getSpecific();
        Map<String, CountID> minor = registeredIds.get(category);
        if (minor == null) {
            return;
        }
        CountID countid = minor.get(specific);
        if (countid == null) {
            return;
        }
        ++countid.count;
        countid.lastPortalException = pe;
        recentIds.remove(countid);
        recentIds.addFirst(countid);
        if (recentIds.size() > maxRecent) {
            recentIds.removeLast();
        }
        recentPortalExceptions.addFirst(pe);
        if (recentPortalExceptions.size() > overallErrorsCount) {
            recentPortalExceptions.removeLast();
        }
    }

    public static synchronized List<PortalException> getRecentPortalExceptions() {
        return Collections.unmodifiableList(new ArrayList<PortalException>(recentPortalExceptions));
    }
}

