/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.portal;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.portal.AuthorizationException;
import org.jasig.portal.IUserIdentityStore;
import org.jasig.portal.RDBMServices;
import org.jasig.portal.groups.IEntity;
import org.jasig.portal.groups.IEntityGroup;
import org.jasig.portal.groups.IGroupMember;
import org.jasig.portal.groups.ILockableEntityGroup;
import org.jasig.portal.properties.PropertiesManager;
import org.jasig.portal.security.IPerson;
import org.jasig.portal.security.PersonFactory;
import org.jasig.portal.services.GroupService;
import org.jasig.portal.services.SequenceGenerator;
import org.jasig.portal.utils.CounterStoreFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class RDBMUserIdentityStore
implements IUserIdentityStore {
    private static final Log log = LogFactory.getLog(RDBMUserIdentityStore.class);
    private static String PROFILE_TABLE = "UP_USER_PROFILE";
    private static final String defaultTemplateUserName = PropertiesManager.getProperty("org.jasig.portal.services.Authentication.defaultTemplateUserName");
    private static final String templateAttrName = "uPortalTemplateUserName";
    private static final int guestUID = 1;
    static int DEBUG = 0;
    private static final ConcurrentMap<String, Object> userLocks = new ConcurrentHashMap<String, Object>();
    private final UserNameRowMapper userNameRowMapper = new UserNameRowMapper();

    private static Object getLock(IPerson person) {
        Object newLock;
        String username = (String)person.getAttribute("username");
        Object lock = userLocks.putIfAbsent(username, newLock = new Object());
        if (lock == null) {
            return newLock;
        }
        return lock;
    }

    private static void removeLock(IPerson person) {
        String username = (String)person.getAttribute("username");
        userLocks.remove(username);
    }

    @Override
    public int getPortalUID(IPerson person) throws Exception {
        int uPortalUID = -1;
        uPortalUID = this.getPortalUID(person, false);
        return uPortalUID;
    }

    @Override
    public void removePortalUID(int uPortalUID) throws Exception {
        Connection con = RDBMServices.getConnection();
        PreparedStatement ps = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.createStatement();
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.setAutoCommit(false);
            }
            rs = stmt.executeQuery("SELECT USER_NAME FROM UP_USER WHERE USER_ID=" + uPortalUID);
            String name = "";
            if (rs.next()) {
                name = rs.getString(1);
            }
            rs.close();
            rs = stmt.executeQuery("SELECT ENTITY_TYPE_ID FROM UP_ENTITY_TYPE WHERE ENTITY_TYPE_NAME = 'org.jasig.portal.security.IPerson'");
            int type = -1;
            if (rs.next()) {
                type = rs.getInt(1);
            }
            rs.close();
            rs = null;
            String SQLDelete = "DELETE FROM UP_PERMISSION WHERE PRINCIPAL_KEY='" + name + "' AND PRINCIPAL_TYPE=" + type;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            rs = stmt.executeQuery("SELECT M.GROUP_ID FROM UP_GROUP_MEMBERSHIP M, UP_GROUP G, UP_ENTITY_TYPE E WHERE M.GROUP_ID = G.GROUP_ID   AND G.ENTITY_TYPE_ID = E.ENTITY_TYPE_ID   AND  E.ENTITY_TYPE_NAME = 'org.jasig.portal.security.IPerson'  AND  M.MEMBER_KEY ='" + name + "' AND  M.MEMBER_IS_GROUP = 'F'");
            Vector<String> groups = new Vector<String>();
            while (rs.next()) {
                groups.add(rs.getString(1));
            }
            rs.close();
            rs = null;
            ps = con.prepareStatement("DELETE FROM UP_GROUP_MEMBERSHIP WHERE MEMBER_KEY='" + name + "' AND GROUP_ID=?");
            for (int i = 0; i < groups.size(); ++i) {
                String group = (String)groups.get(i);
                ps.setString(1, group);
                ps.executeUpdate();
            }
            if (ps != null) {
                ps.close();
            }
            SQLDelete = "DELETE FROM UP_USER WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_LAYOUT  WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_PARAM WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_PROFILE  WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_LAYOUT    WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_SS_USER_ATTS WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_SS_USER_PARM  WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_LAYOUT_PARAM WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_UA_MAP WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_LAYOUT_STRUCT  WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_LOCALE WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_PROFILE_MDATA WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_PROFILE_LOCALE WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_USER_LAYOUT_MDATA WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            SQLDelete = "DELETE FROM UP_LAYOUT_STRUCT_MDATA  WHERE USER_ID = " + uPortalUID;
            if (log.isDebugEnabled()) {
                log.debug((Object)("RDBMUserIdentityStore::removePortalUID(): " + SQLDelete));
            }
            stmt.executeUpdate(SQLDelete);
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.commit();
            }
        }
        catch (SQLException se) {
            try {
                try {
                    log.error((Object)("RDBMUserIdentityStore::removePortalUID(): " + se));
                    if (RDBMServices.getDbMetaData().supportsTransactions()) {
                        con.rollback();
                    }
                }
                catch (SQLException e) {
                    log.error((Object)("RDBMUserIdentityStore::removePortalUID(): " + e));
                }
                if (DEBUG > 0) {
                    System.err.println("SQLException: " + se.getMessage());
                    System.err.println("SQLState:  " + se.getSQLState());
                    System.err.println("Message:  " + se.getMessage());
                    System.err.println("Vendor:  " + se.getErrorCode());
                }
                throw se;
            }
            catch (Throwable throwable) {
                RDBMServices.closeResultSet(rs);
                RDBMServices.closeStatement(stmt);
                RDBMServices.closeStatement(ps);
                RDBMServices.releaseConnection(con);
                throw throwable;
            }
        }
        RDBMServices.closeResultSet(rs);
        RDBMServices.closeStatement(stmt);
        RDBMServices.closeStatement(ps);
        RDBMServices.releaseConnection(con);
    }

    @Override
    public String getUsername(IPerson person) {
        return (String)person.getAttribute("username");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getPortalUID(IPerson person, boolean createPortalData) throws AuthorizationException {
        int uid;
        String username = (String)person.getAttribute("username");
        if (PersonFactory.GUEST_USERNAME.equals(username)) {
            uid = this.__getPortalUID(person, createPortalData);
        } else {
            Object lock;
            Object object = lock = RDBMUserIdentityStore.getLock(person);
            synchronized (object) {
                uid = this.__getPortalUID(person, createPortalData);
            }
            RDBMUserIdentityStore.removeLock(person);
        }
        return uid;
    }

    @Override
    public String getPortalUserName(int uPortalUID) {
        DataSource dataSource = RDBMServices.getDataSource();
        SimpleJdbcTemplate simpleJdbcTemplate = new SimpleJdbcTemplate(dataSource);
        List results = simpleJdbcTemplate.query("SELECT USER_NAME FROM UP_USER WHERE USER_ID=?", (ParameterizedRowMapper)this.userNameRowMapper, new Object[]{uPortalUID});
        String userName = (String)DataAccessUtils.singleResult((Collection)results);
        return userName;
    }

    private int __getPortalUID(IPerson person, boolean createPortalData) throws AuthorizationException {
        PortalUser portalUser = null;
        try {
            String userName = this.getUsername(person);
            String templateName = this.getTemplateName(person);
            portalUser = this.getPortalUser(userName);
            if (createPortalData) {
                if (portalUser != null) {
                    boolean hasSavedLayout = this.userHasSavedLayout(portalUser.getUserId());
                    if (!hasSavedLayout) {
                        TemplateUser templateUser = this.getTemplateUser(templateName);
                        if (portalUser.getDefaultUserId() != templateUser.getUserId()) {
                            this.updateUser(portalUser.getUserId(), person, templateUser);
                        }
                    }
                } else {
                    TemplateUser templateUser = this.getTemplateUser(templateName);
                    if (templateUser == null) {
                        throw new AuthorizationException("No information found for template user = " + templateName + ". Cannot create new account for " + userName);
                    }
                    int newUID = this.getNewPortalUID(person);
                    int newPortalUID = this.addNewUser(newUID, person, templateUser);
                    portalUser = new PortalUser();
                    portalUser.setUserId(newPortalUID);
                }
            } else if (portalUser == null) {
                throw new AuthorizationException("No portal information exists for user " + userName);
            }
        }
        catch (Exception e) {
            if (e instanceof AuthorizationException) {
                throw (AuthorizationException)e;
            }
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new AuthorizationException(e);
        }
        return portalUser.getUserId();
    }

    protected int getNewPortalUID(IPerson person) throws Exception {
        return CounterStoreFactory.getCounterStoreImpl().getIncrementIntegerId("UP_USER");
    }

    protected static final void commit(Connection connection) {
        try {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                connection.commit();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMUserIdentityStore::commit(): " + e));
        }
    }

    protected static final void rollback(Connection connection) {
        try {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                connection.rollback();
            }
        }
        catch (Exception e) {
            log.error((Object)("RDBMUserIdentityStore::rollback(): " + e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PortalUser getPortalUser(String userName) throws Exception {
        PortalUser portalUser = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement pstmt = null;
            try {
                String query = "SELECT USER_ID, USER_DFLT_USR_ID FROM UP_USER WHERE USER_NAME=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, userName);
                ResultSet rs = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::getPortalUID(userName=" + userName + "): " + query));
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        portalUser = new PortalUser();
                        portalUser.setUserId(rs.getInt("USER_ID"));
                        portalUser.setUserName(userName);
                        portalUser.setDefaultUserId(rs.getInt("USER_DFLT_USR_ID"));
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
        return portalUser;
    }

    protected String getTemplateName(IPerson person) {
        String templateName = (String)person.getAttribute(templateAttrName);
        if (templateName == null || templateName.equals("")) {
            templateName = defaultTemplateUserName;
        }
        return templateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TemplateUser getTemplateUser(String templateUserName) throws Exception {
        TemplateUser templateUser = null;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement pstmt = null;
            try {
                String query = "SELECT USER_ID, USER_DFLT_LAY_ID FROM UP_USER WHERE USER_NAME=?";
                pstmt = con.prepareStatement(query);
                pstmt.setString(1, templateUserName);
                ResultSet rs = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::getTemplateUser(templateUserName=" + templateUserName + "): " + query));
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        templateUser = new TemplateUser();
                        templateUser.setUserName(templateUserName);
                        templateUser.setUserId(rs.getInt("USER_ID"));
                        templateUser.setDefaultLayoutId(rs.getInt("USER_DFLT_LAY_ID"));
                    } else if (!templateUserName.equals(defaultTemplateUserName)) {
                        templateUser = this.getTemplateUser(defaultTemplateUserName);
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
        return templateUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean userHasSavedLayout(int userId) throws Exception {
        boolean userHasSavedLayout = false;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            Statement pstmt = null;
            try {
                String query = "SELECT * FROM UP_USER_PROFILE WHERE USER_ID=? AND LAYOUT_ID IS NOT NULL AND LAYOUT_ID!=0";
                pstmt = con.prepareStatement(query);
                pstmt.setInt(1, userId);
                ResultSet rs = null;
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::getTemplateUser(userId=" + userId + "): " + query));
                    }
                    if ((rs = pstmt.executeQuery()).next()) {
                        userHasSavedLayout = true;
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    pstmt.close();
                }
                catch (Exception e) {}
            }
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
        return userHasSavedLayout;
    }

    private ILockableEntityGroup getSafeLockableGroup(IEntityGroup eg, IGroupMember gm) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Creating lockable group for group/member: " + eg + "/" + gm));
        }
        ILockableEntityGroup leg = null;
        try {
            if (eg.isEditable()) {
                leg = GroupService.findLockableGroup(eg.getKey(), gm.getKey());
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to create lockable group for group/member: " + eg + "/" + gm), (Throwable)e);
        }
        return leg;
    }

    private void removePersonFromGroup(IPerson person, IGroupMember me, IEntityGroup eg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Removing " + person + " from group " + eg));
        }
        try {
            if (eg.isEditable()) {
                eg.removeMember(me);
                eg.updateMembers();
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to remove " + person + " from group " + eg), (Throwable)e);
        }
    }

    private void addPersonToGroup(IPerson person, IGroupMember me, IEntityGroup eg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Adding " + person + " to group " + eg));
        }
        try {
            if (eg.isEditable()) {
                eg.addMember(me);
                eg.updateMembers();
            }
        }
        catch (Exception e) {
            log.error((Object)("Unable to add " + person + " to group " + eg), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUser(int userId, IPerson person, TemplateUser templateUser) throws Exception {
        IGroupMember me = GroupService.getGroupMember(person.getEntityIdentifier());
        Iterator myExistingGroups = me.getContainingGroups();
        while (myExistingGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)myExistingGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.removePersonFromGroup(person, me, leg);
        }
        IEntity template = GroupService.getEntity(templateUser.getUserName(), Class.forName("org.jasig.portal.security.IPerson"));
        Iterator templateGroups = template.getContainingGroups();
        while (templateGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)templateGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.addPersonToGroup(person, me, leg);
        }
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.setAutoCommit(false);
            }
            Statement deleteStmt = null;
            Statement queryStmt = null;
            PreparedStatement insertStmt = null;
            try {
                String update = "UPDATE UP_USER SET USER_DFLT_USR_ID=?, USER_DFLT_LAY_ID=?, NEXT_STRUCT_ID=null WHERE USER_ID=?";
                insertStmt = con.prepareStatement(update);
                insertStmt.setInt(1, templateUser.getUserId());
                insertStmt.setInt(2, templateUser.getDefaultLayoutId());
                insertStmt.setInt(3, userId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMUserIdentityStore::addNewUser(): " + update));
                }
                insertStmt.executeUpdate();
                insertStmt.close();
                ResultSet rs = null;
                String delete = null;
                String query = null;
                String insert = null;
                try {
                    delete = "DELETE FROM UP_USER_PARAM WHERE USER_ID=?";
                    deleteStmt = con.prepareStatement(delete);
                    deleteStmt.setInt(1, userId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + userId + "): " + delete));
                    }
                    deleteStmt.executeUpdate();
                    deleteStmt.close();
                    query = "SELECT USER_ID, USER_PARAM_NAME, USER_PARAM_VALUE FROM UP_USER_PARAM WHERE USER_ID=?";
                    queryStmt = con.prepareStatement(query);
                    queryStmt.setInt(1, templateUser.getUserId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + templateUser.getUserId() + "): " + query));
                    }
                    rs = queryStmt.executeQuery();
                    insert = "INSERT INTO UP_USER_PARAM (USER_ID, USER_PARAM_NAME, USER_PARAM_VALUE) VALUES(?, ?, ?)";
                    insertStmt = con.prepareStatement(insert);
                    while (rs.next()) {
                        String userParamName = rs.getString("USER_PARAM_NAME");
                        String userParamValue = rs.getString("USER_PARAM_VALUE");
                        insertStmt.setInt(1, userId);
                        insertStmt.setString(2, userParamName);
                        insertStmt.setString(3, userParamValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + userId + ", USER_PARAM_NAME=" + userParamName + ", USER_PARAM_VALUE=" + userParamValue + "): " + insert));
                        }
                        insertStmt.executeUpdate();
                    }
                    rs.close();
                    queryStmt.close();
                    insertStmt.close();
                    delete = "DELETE FROM UP_USER_PROFILE WHERE USER_ID=?";
                    deleteStmt = con.prepareStatement(delete);
                    deleteStmt.setInt(1, userId);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + userId + "): " + delete));
                    }
                    deleteStmt.executeUpdate();
                    deleteStmt.close();
                    query = "SELECT USER_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=?";
                    queryStmt = con.prepareStatement(query);
                    queryStmt.setInt(1, templateUser.getUserId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + templateUser.getUserId() + "): " + query));
                    }
                    rs = queryStmt.executeQuery();
                    insert = "INSERT INTO UP_USER_PROFILE (USER_ID, PROFILE_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID) VALUES(?, ?, ?, ?, ?, NULL, ?, ?)";
                    insertStmt = con.prepareStatement(insert);
                    while (rs.next()) {
                        int id = this.getNextKey();
                        String profileFname = rs.getString("PROFILE_FNAME");
                        String profileName = rs.getString("PROFILE_NAME");
                        String description = rs.getString("DESCRIPTION");
                        int structure = rs.getInt("STRUCTURE_SS_ID");
                        int theme = rs.getInt("THEME_SS_ID");
                        insertStmt.setInt(1, userId);
                        insertStmt.setInt(2, id);
                        insertStmt.setString(3, profileFname);
                        insertStmt.setString(4, profileName);
                        insertStmt.setString(5, description);
                        insertStmt.setInt(6, structure);
                        insertStmt.setInt(7, theme);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RDBMUserIdentityStore::updateUser(USER_ID=" + userId + ", PROFILE_FNAME=" + profileFname + ", PROFILE_NAME=" + profileName + ", DESCRIPTION=" + description + "): " + insert));
                        }
                        insertStmt.executeUpdate();
                    }
                    rs.close();
                    queryStmt.close();
                    insertStmt.close();
                    if (RDBMServices.getDbMetaData().supportsTransactions()) {
                        con.commit();
                    }
                }
                finally {
                    try {
                        rs.close();
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    deleteStmt.close();
                }
                catch (Exception e) {}
                try {
                    queryStmt.close();
                }
                catch (Exception e) {}
                try {
                    insertStmt.close();
                }
                catch (Exception e) {}
            }
        }
        catch (SQLException sqle) {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.rollback();
            }
            throw new AuthorizationException("SQL database error while retrieving user's portal UID", (Throwable)sqle);
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addNewUser(int newUID, IPerson person, TemplateUser templateUser) throws Exception {
        IGroupMember me = GroupService.getGroupMember(person.getEntityIdentifier());
        IEntity template = GroupService.getEntity(templateUser.getUserName(), Class.forName("org.jasig.portal.security.IPerson"));
        Iterator templateGroups = template.getContainingGroups();
        while (templateGroups.hasNext()) {
            IEntityGroup eg = (IEntityGroup)templateGroups.next();
            ILockableEntityGroup leg = this.getSafeLockableGroup(eg, me);
            if (leg == null) continue;
            this.addPersonToGroup(person, me, leg);
        }
        int uPortalUID = -1;
        Connection con = null;
        try {
            con = RDBMServices.getConnection();
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.setAutoCommit(false);
            }
            Statement queryStmt = null;
            PreparedStatement insertStmt = null;
            try {
                String insert = "INSERT INTO UP_USER (USER_ID, USER_NAME, USER_DFLT_USR_ID, USER_DFLT_LAY_ID, NEXT_STRUCT_ID, LST_CHAN_UPDT_DT)VALUES (?, ?, ?, ?, null, null)";
                String userName = this.getUsername(person);
                insertStmt = con.prepareStatement(insert);
                insertStmt.setInt(1, newUID);
                insertStmt.setString(2, userName);
                insertStmt.setInt(3, templateUser.getUserId());
                insertStmt.setInt(4, templateUser.getDefaultLayoutId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RDBMUserIdentityStore::addNewUser(USER_ID=" + newUID + ", USER_NAME=" + userName + ", USER_DFLT_USR_ID=" + templateUser.getUserId() + ", USER_DFLT_LAY_ID=" + templateUser.getDefaultLayoutId() + "): " + insert));
                }
                insertStmt.executeUpdate();
                insertStmt.close();
                insertStmt = null;
                ResultSet rs = null;
                String query = null;
                try {
                    query = "SELECT USER_ID, USER_PARAM_NAME, USER_PARAM_VALUE FROM UP_USER_PARAM WHERE USER_ID=?";
                    queryStmt = con.prepareStatement(query);
                    queryStmt.setInt(1, templateUser.getUserId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::addNewUser(USER_ID=" + templateUser.getUserId() + "): " + query));
                    }
                    rs = queryStmt.executeQuery();
                    insert = "INSERT INTO UP_USER_PARAM (USER_ID, USER_PARAM_NAME, USER_PARAM_VALUE) VALUES(?, ?, ?)";
                    insertStmt = con.prepareStatement(insert);
                    while (rs.next()) {
                        String userParamName = rs.getString("USER_PARAM_NAME");
                        String userParamValue = rs.getString("USER_PARAM_VALUE");
                        insertStmt.setInt(1, newUID);
                        insertStmt.setString(2, userParamName);
                        insertStmt.setString(3, userParamValue);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RDBMUserIdentityStore::addNewUser(USER_ID=" + newUID + ", USER_PARAM_NAME=" + userParamName + ", USER_PARAM_VALUE=" + userParamValue + "): " + insert));
                        }
                        insertStmt.executeUpdate();
                    }
                    rs.close();
                    queryStmt.close();
                    if (insertStmt != null) {
                        insertStmt.close();
                        insertStmt = null;
                    }
                    query = "SELECT USER_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, STRUCTURE_SS_ID, THEME_SS_ID FROM UP_USER_PROFILE WHERE USER_ID=?";
                    queryStmt = con.prepareStatement(query);
                    queryStmt.setInt(1, templateUser.getUserId());
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("RDBMUserIdentityStore::addNewUser(USER_ID=" + templateUser.getUserId() + "): " + query));
                    }
                    rs = queryStmt.executeQuery();
                    insert = "INSERT INTO UP_USER_PROFILE (USER_ID, PROFILE_ID, PROFILE_FNAME, PROFILE_NAME, DESCRIPTION, LAYOUT_ID, STRUCTURE_SS_ID, THEME_SS_ID) VALUES(?, ?, ?, ?, ?, NULL, ?, ?)";
                    insertStmt = con.prepareStatement(insert);
                    while (rs.next()) {
                        int id = this.getNextKey();
                        String profileFname = rs.getString("PROFILE_FNAME");
                        String profileName = rs.getString("PROFILE_NAME");
                        String description = rs.getString("DESCRIPTION");
                        int structure = rs.getInt("STRUCTURE_SS_ID");
                        int theme = rs.getInt("THEME_SS_ID");
                        insertStmt.setInt(1, newUID);
                        insertStmt.setInt(2, id);
                        insertStmt.setString(3, profileFname);
                        insertStmt.setString(4, profileName);
                        insertStmt.setString(5, description);
                        insertStmt.setInt(6, structure);
                        insertStmt.setInt(7, theme);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RDBMUserIdentityStore::addNewUser(USER_ID=" + newUID + ", PROFILE_FNAME=" + profileFname + ", PROFILE_NAME=" + profileName + ", DESCRIPTION=" + description + "): " + insert));
                        }
                        insertStmt.executeUpdate();
                    }
                    rs.close();
                    queryStmt.close();
                    if (insertStmt != null) {
                        insertStmt.close();
                        insertStmt = null;
                    }
                    if (RDBMServices.getDbMetaData().supportsTransactions()) {
                        con.commit();
                    }
                    uPortalUID = newUID;
                }
                finally {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                    catch (Exception e) {}
                }
            }
            finally {
                try {
                    if (queryStmt != null) {
                        queryStmt.close();
                    }
                }
                catch (Exception e) {}
                try {
                    if (insertStmt != null) {
                        insertStmt.close();
                    }
                }
                catch (Exception e) {}
            }
        }
        catch (SQLException sqle) {
            if (RDBMServices.getDbMetaData().supportsTransactions()) {
                con.rollback();
            }
            throw new AuthorizationException("SQL database error while retrieving user's portal UID", (Throwable)sqle);
        }
        finally {
            try {
                RDBMServices.releaseConnection(con);
            }
            catch (Exception e) {}
        }
        return uPortalUID;
    }

    private int getNextKey() throws Exception {
        return SequenceGenerator.instance().getNextInt(PROFILE_TABLE);
    }

    protected class TemplateUser {
        String userName;
        int userId;
        int defaultLayoutId;

        protected TemplateUser() {
        }

        public String getUserName() {
            return this.userName;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getDefaultLayoutId() {
            return this.defaultLayoutId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public void setDefaultLayoutId(int defaultLayoutId) {
            this.defaultLayoutId = defaultLayoutId;
        }
    }

    protected class PortalUser {
        String userName;
        int userId;
        int defaultUserId;

        protected PortalUser() {
        }

        public String getUserName() {
            return this.userName;
        }

        public int getUserId() {
            return this.userId;
        }

        public int getDefaultUserId() {
            return this.defaultUserId;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public void setUserId(int userId) {
            this.userId = userId;
        }

        public void setDefaultUserId(int defaultUserId) {
            this.defaultUserId = defaultUserId;
        }
    }

    private class UserNameRowMapper
    implements ParameterizedRowMapper<String> {
        private UserNameRowMapper() {
        }

        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
            return rs.getString("USER_NAME");
        }
    }
}

